package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openconfig.types.rev190416.AvgMinMaxInstantStatsPct;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openconfig.types.rev190416.MinMaxTime;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openconfig.types.rev190416.Percentage;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openconfig.types.rev190416.StatInterval;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openconfig.types.rev190416.StatIntervalState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openconfig.types.rev190416.Timeticks64;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link User} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     User createUser(int fooXyzzy, int barBaz) {
 *         return new UserBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of User, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see User
 *
 */
@Generated("mdsal-binding-generator")
public class UserBuilder {

    private Percentage _avg;
    private Percentage _instant;
    private StatInterval _interval;
    private Percentage _max;
    private Timeticks64 _maxTime;
    private Percentage _min;
    private Timeticks64 _minTime;


    Map<Class<? extends Augmentation<User>>, Augmentation<User>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public UserBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link AvgMinMaxInstantStatsPct}.
     *
     * @param arg AvgMinMaxInstantStatsPct from which the builder should be initialized
     */
    public UserBuilder(AvgMinMaxInstantStatsPct arg) {
        this._instant = arg.getInstant();
        this._avg = arg.getAvg();
        this._min = arg.getMin();
        this._max = arg.getMax();
        this._interval = arg.getInterval();
        this._minTime = arg.getMinTime();
        this._maxTime = arg.getMaxTime();
    }
    
    /**
     * Construct a new builder initialized from specified {@link StatIntervalState}.
     *
     * @param arg StatIntervalState from which the builder should be initialized
     */
    public UserBuilder(StatIntervalState arg) {
        this._interval = arg.getInterval();
    }
    
    /**
     * Construct a new builder initialized from specified {@link MinMaxTime}.
     *
     * @param arg MinMaxTime from which the builder should be initialized
     */
    public UserBuilder(MinMaxTime arg) {
        this._minTime = arg.getMinTime();
        this._maxTime = arg.getMaxTime();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link User}.
     *
     * @param base User from which the builder should be initialized
     */
    public UserBuilder(User base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._avg = base.getAvg();
        this._instant = base.getInstant();
        this._interval = base.getInterval();
        this._max = base.getMax();
        this._maxTime = base.getMaxTime();
        this._min = base.getMin();
        this._minTime = base.getMinTime();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link StatIntervalState}</li>
     *   <li>{@link MinMaxTime}</li>
     *   <li>{@link AvgMinMaxInstantStatsPct}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof StatIntervalState castArg) {
            this._interval = castArg.getInterval();
            isValidArg = true;
        }
        if (arg instanceof MinMaxTime castArg) {
            this._minTime = castArg.getMinTime();
            this._maxTime = castArg.getMaxTime();
            isValidArg = true;
        }
        if (arg instanceof AvgMinMaxInstantStatsPct castArg) {
            this._instant = castArg.getInstant();
            this._avg = castArg.getAvg();
            this._min = castArg.getMin();
            this._max = castArg.getMax();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[StatIntervalState, MinMaxTime, AvgMinMaxInstantStatsPct]");
    }

    /**
     * Return current value associated with the property corresponding to {@link User#getAvg()}.
     *
     * @return current value
     */
    public Percentage getAvg() {
        return _avg;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link User#getInstant()}.
     *
     * @return current value
     */
    public Percentage getInstant() {
        return _instant;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link User#getInterval()}.
     *
     * @return current value
     */
    public StatInterval getInterval() {
        return _interval;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link User#getMax()}.
     *
     * @return current value
     */
    public Percentage getMax() {
        return _max;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link User#getMaxTime()}.
     *
     * @return current value
     */
    public Timeticks64 getMaxTime() {
        return _maxTime;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link User#getMin()}.
     *
     * @return current value
     */
    public Percentage getMin() {
        return _min;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link User#getMinTime()}.
     *
     * @return current value
     */
    public Timeticks64 getMinTime() {
        return _minTime;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<User>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link User#getAvg()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public UserBuilder setAvg(final Percentage value) {
        this._avg = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link User#getInstant()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public UserBuilder setInstant(final Percentage value) {
        this._instant = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link User#getInterval()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public UserBuilder setInterval(final StatInterval value) {
        this._interval = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link User#getMax()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public UserBuilder setMax(final Percentage value) {
        this._max = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link User#getMaxTime()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public UserBuilder setMaxTime(final Timeticks64 value) {
        this._maxTime = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link User#getMin()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public UserBuilder setMin(final Percentage value) {
        this._min = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link User#getMinTime()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public UserBuilder setMinTime(final Timeticks64 value) {
        this._minTime = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public UserBuilder addAugmentation(Augmentation<User> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public UserBuilder removeAugmentation(Class<? extends Augmentation<User>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link User} instance.
     *
     * @return A new {@link User} instance.
     */
    public @NonNull User build() {
        return new UserImpl(this);
    }

    private static final class UserImpl
        extends AbstractAugmentable<User>
        implements User {
    
        private final Percentage _avg;
        private final Percentage _instant;
        private final StatInterval _interval;
        private final Percentage _max;
        private final Timeticks64 _maxTime;
        private final Percentage _min;
        private final Timeticks64 _minTime;
    
        UserImpl(UserBuilder base) {
            super(base.augmentation);
            this._avg = base.getAvg();
            this._instant = base.getInstant();
            this._interval = base.getInterval();
            this._max = base.getMax();
            this._maxTime = base.getMaxTime();
            this._min = base.getMin();
            this._minTime = base.getMinTime();
        }
    
        @Override
        public Percentage getAvg() {
            return _avg;
        }
        
        @Override
        public Percentage getInstant() {
            return _instant;
        }
        
        @Override
        public StatInterval getInterval() {
            return _interval;
        }
        
        @Override
        public Percentage getMax() {
            return _max;
        }
        
        @Override
        public Timeticks64 getMaxTime() {
            return _maxTime;
        }
        
        @Override
        public Percentage getMin() {
            return _min;
        }
        
        @Override
        public Timeticks64 getMinTime() {
            return _minTime;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = User.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return User.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return User.bindingToString(this);
        }
    }
}
