package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.top.components.component;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.PlatformComponentConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.PlatformComponentMemoryState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.PlatformComponentPowerState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.PlatformComponentState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.PlatformComponentState.Type;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.PlatformComponentTempState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.memory.state.Memory;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.temp.state.Temperature;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.types.rev210118.COMPONENTOPERSTATUS;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.yang.rev210302.Date;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Class that builds {@link State} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     State createState(int fooXyzzy, int barBaz) {
 *         return new StateBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of State, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see State
 *
 */
@Generated("mdsal-binding-generator")
public class StateBuilder {

    private Uint32 _allocatedPower;
    private String _description;
    private Boolean _empty;
    private String _firmwareVersion;
    private String _hardwareVersion;
    private String _id;
    private String _location;
    private Memory _memory;
    private Date _mfgDate;
    private String _mfgName;
    private String _name;
    private COMPONENTOPERSTATUS _operStatus;
    private String _parent;
    private String _partNo;
    private Boolean _removable;
    private String _serialNo;
    private String _softwareVersion;
    private Temperature _temperature;
    private Type _type;
    private Uint32 _usedPower;


    Map<Class<? extends Augmentation<State>>, Augmentation<State>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public StateBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link PlatformComponentConfig}.
     *
     * @param arg PlatformComponentConfig from which the builder should be initialized
     */
    public StateBuilder(PlatformComponentConfig arg) {
        this._name = arg.getName();
    }
    
    
    /**
     * Construct a new builder initialized from specified {@link PlatformComponentState}.
     *
     * @param arg PlatformComponentState from which the builder should be initialized
     */
    public StateBuilder(PlatformComponentState arg) {
        this._type = arg.getType();
        this._id = arg.getId();
        this._location = arg.getLocation();
        this._description = arg.getDescription();
        this._mfgName = arg.getMfgName();
        this._mfgDate = arg.getMfgDate();
        this._hardwareVersion = arg.getHardwareVersion();
        this._firmwareVersion = arg.getFirmwareVersion();
        this._softwareVersion = arg.getSoftwareVersion();
        this._serialNo = arg.getSerialNo();
        this._partNo = arg.getPartNo();
        this._removable = arg.getRemovable();
        this._operStatus = arg.getOperStatus();
        this._empty = arg.getEmpty();
        this._parent = CodeHelpers.checkFieldCast(String.class, "parent", arg.getParent());
    }
    
    
    /**
     * Construct a new builder initialized from specified {@link PlatformComponentTempState}.
     *
     * @param arg PlatformComponentTempState from which the builder should be initialized
     */
    public StateBuilder(PlatformComponentTempState arg) {
        this._temperature = arg.getTemperature();
    }
    
    
    /**
     * Construct a new builder initialized from specified {@link PlatformComponentMemoryState}.
     *
     * @param arg PlatformComponentMemoryState from which the builder should be initialized
     */
    public StateBuilder(PlatformComponentMemoryState arg) {
        this._memory = arg.getMemory();
    }
    
    
    /**
     * Construct a new builder initialized from specified {@link PlatformComponentPowerState}.
     *
     * @param arg PlatformComponentPowerState from which the builder should be initialized
     */
    public StateBuilder(PlatformComponentPowerState arg) {
        this._allocatedPower = arg.getAllocatedPower();
        this._usedPower = arg.getUsedPower();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link State}.
     *
     * @param base State from which the builder should be initialized
     */
    public StateBuilder(State base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._allocatedPower = base.getAllocatedPower();
        this._description = base.getDescription();
        this._empty = base.getEmpty();
        this._firmwareVersion = base.getFirmwareVersion();
        this._hardwareVersion = base.getHardwareVersion();
        this._id = base.getId();
        this._location = base.getLocation();
        this._memory = base.getMemory();
        this._mfgDate = base.getMfgDate();
        this._mfgName = base.getMfgName();
        this._name = base.getName();
        this._operStatus = base.getOperStatus();
        this._parent = base.getParent();
        this._partNo = base.getPartNo();
        this._removable = base.getRemovable();
        this._serialNo = base.getSerialNo();
        this._softwareVersion = base.getSoftwareVersion();
        this._temperature = base.getTemperature();
        this._type = base.getType();
        this._usedPower = base.getUsedPower();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link PlatformComponentTempState}</li>
     *   <li>{@link PlatformComponentMemoryState}</li>
     *   <li>{@link PlatformComponentPowerState}</li>
     *   <li>{@link PlatformComponentConfig}</li>
     *   <li>{@link PlatformComponentState}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof PlatformComponentTempState castArg) {
            this._temperature = castArg.getTemperature();
            isValidArg = true;
        }
        if (arg instanceof PlatformComponentMemoryState castArg) {
            this._memory = castArg.getMemory();
            isValidArg = true;
        }
        if (arg instanceof PlatformComponentPowerState castArg) {
            this._allocatedPower = castArg.getAllocatedPower();
            this._usedPower = castArg.getUsedPower();
            isValidArg = true;
        }
        if (arg instanceof PlatformComponentConfig castArg) {
            this._name = castArg.getName();
            isValidArg = true;
        }
        if (arg instanceof PlatformComponentState castArg) {
            this._type = castArg.getType();
            this._id = castArg.getId();
            this._location = castArg.getLocation();
            this._description = castArg.getDescription();
            this._mfgName = castArg.getMfgName();
            this._mfgDate = castArg.getMfgDate();
            this._hardwareVersion = castArg.getHardwareVersion();
            this._firmwareVersion = castArg.getFirmwareVersion();
            this._softwareVersion = castArg.getSoftwareVersion();
            this._serialNo = castArg.getSerialNo();
            this._partNo = castArg.getPartNo();
            this._removable = castArg.getRemovable();
            this._operStatus = castArg.getOperStatus();
            this._empty = castArg.getEmpty();
            this._parent = CodeHelpers.checkFieldCast(String.class, "parent", castArg.getParent());
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[PlatformComponentTempState, PlatformComponentMemoryState, PlatformComponentPowerState, PlatformComponentConfig, PlatformComponentState]");
    }

    /**
     * Return current value associated with the property corresponding to {@link State#getAllocatedPower()}.
     *
     * @return current value
     */
    public Uint32 getAllocatedPower() {
        return _allocatedPower;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getDescription()}.
     *
     * @return current value
     */
    public String getDescription() {
        return _description;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getEmpty()}.
     *
     * @return current value
     */
    public Boolean getEmpty() {
        return _empty;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getFirmwareVersion()}.
     *
     * @return current value
     */
    public String getFirmwareVersion() {
        return _firmwareVersion;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getHardwareVersion()}.
     *
     * @return current value
     */
    public String getHardwareVersion() {
        return _hardwareVersion;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getId()}.
     *
     * @return current value
     */
    public String getId() {
        return _id;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getLocation()}.
     *
     * @return current value
     */
    public String getLocation() {
        return _location;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getMemory()}.
     *
     * @return current value
     */
    public Memory getMemory() {
        return _memory;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getMfgDate()}.
     *
     * @return current value
     */
    public Date getMfgDate() {
        return _mfgDate;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getMfgName()}.
     *
     * @return current value
     */
    public String getMfgName() {
        return _mfgName;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getName()}.
     *
     * @return current value
     */
    public String getName() {
        return _name;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getOperStatus()}.
     *
     * @return current value
     */
    public COMPONENTOPERSTATUS getOperStatus() {
        return _operStatus;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getParent()}.
     *
     * @return current value
     */
    public String getParent() {
        return _parent;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getPartNo()}.
     *
     * @return current value
     */
    public String getPartNo() {
        return _partNo;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getRemovable()}.
     *
     * @return current value
     */
    public Boolean getRemovable() {
        return _removable;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getSerialNo()}.
     *
     * @return current value
     */
    public String getSerialNo() {
        return _serialNo;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getSoftwareVersion()}.
     *
     * @return current value
     */
    public String getSoftwareVersion() {
        return _softwareVersion;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getTemperature()}.
     *
     * @return current value
     */
    public Temperature getTemperature() {
        return _temperature;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getType()}.
     *
     * @return current value
     */
    public Type getType() {
        return _type;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getUsedPower()}.
     *
     * @return current value
     */
    public Uint32 getUsedPower() {
        return _usedPower;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<State>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link State#getAllocatedPower()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setAllocatedPower(final Uint32 value) {
        this._allocatedPower = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getDescription()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setDescription(final String value) {
        this._description = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getEmpty()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setEmpty(final Boolean value) {
        this._empty = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getFirmwareVersion()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setFirmwareVersion(final String value) {
        this._firmwareVersion = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getHardwareVersion()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setHardwareVersion(final String value) {
        this._hardwareVersion = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getId()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setId(final String value) {
        this._id = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getLocation()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setLocation(final String value) {
        this._location = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getMemory()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setMemory(final Memory value) {
        this._memory = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getMfgDate()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setMfgDate(final Date value) {
        this._mfgDate = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getMfgName()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setMfgName(final String value) {
        this._mfgName = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getName()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setName(final String value) {
        this._name = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getOperStatus()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setOperStatus(final COMPONENTOPERSTATUS value) {
        this._operStatus = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getParent()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setParent(final String value) {
        this._parent = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getPartNo()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setPartNo(final String value) {
        this._partNo = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getRemovable()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setRemovable(final Boolean value) {
        this._removable = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getSerialNo()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setSerialNo(final String value) {
        this._serialNo = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getSoftwareVersion()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setSoftwareVersion(final String value) {
        this._softwareVersion = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getTemperature()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setTemperature(final Temperature value) {
        this._temperature = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getType()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setType(final Type value) {
        this._type = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getUsedPower()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setUsedPower(final Uint32 value) {
        this._usedPower = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public StateBuilder addAugmentation(Augmentation<State> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public StateBuilder removeAugmentation(Class<? extends Augmentation<State>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link State} instance.
     *
     * @return A new {@link State} instance.
     */
    public @NonNull State build() {
        return new StateImpl(this);
    }

    private static final class StateImpl
        extends AbstractAugmentable<State>
        implements State {
    
        private final Uint32 _allocatedPower;
        private final String _description;
        private final Boolean _empty;
        private final String _firmwareVersion;
        private final String _hardwareVersion;
        private final String _id;
        private final String _location;
        private final Memory _memory;
        private final Date _mfgDate;
        private final String _mfgName;
        private final String _name;
        private final COMPONENTOPERSTATUS _operStatus;
        private final String _parent;
        private final String _partNo;
        private final Boolean _removable;
        private final String _serialNo;
        private final String _softwareVersion;
        private final Temperature _temperature;
        private final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.PlatformComponentState.Type _type;
        private final Uint32 _usedPower;
    
        StateImpl(StateBuilder base) {
            super(base.augmentation);
            this._allocatedPower = base.getAllocatedPower();
            this._description = base.getDescription();
            this._empty = base.getEmpty();
            this._firmwareVersion = base.getFirmwareVersion();
            this._hardwareVersion = base.getHardwareVersion();
            this._id = base.getId();
            this._location = base.getLocation();
            this._memory = base.getMemory();
            this._mfgDate = base.getMfgDate();
            this._mfgName = base.getMfgName();
            this._name = base.getName();
            this._operStatus = base.getOperStatus();
            this._parent = base.getParent();
            this._partNo = base.getPartNo();
            this._removable = base.getRemovable();
            this._serialNo = base.getSerialNo();
            this._softwareVersion = base.getSoftwareVersion();
            this._temperature = base.getTemperature();
            this._type = base.getType();
            this._usedPower = base.getUsedPower();
        }
    
        @Override
        public Uint32 getAllocatedPower() {
            return _allocatedPower;
        }
        
        @Override
        public String getDescription() {
            return _description;
        }
        
        @Override
        public Boolean getEmpty() {
            return _empty;
        }
        
        @Override
        public String getFirmwareVersion() {
            return _firmwareVersion;
        }
        
        @Override
        public String getHardwareVersion() {
            return _hardwareVersion;
        }
        
        @Override
        public String getId() {
            return _id;
        }
        
        @Override
        public String getLocation() {
            return _location;
        }
        
        @Override
        public Memory getMemory() {
            return _memory;
        }
        
        @Override
        public Date getMfgDate() {
            return _mfgDate;
        }
        
        @Override
        public String getMfgName() {
            return _mfgName;
        }
        
        @Override
        public String getName() {
            return _name;
        }
        
        @Override
        public COMPONENTOPERSTATUS getOperStatus() {
            return _operStatus;
        }
        
        @Override
        public String getParent() {
            return _parent;
        }
        
        @Override
        public String getPartNo() {
            return _partNo;
        }
        
        @Override
        public Boolean getRemovable() {
            return _removable;
        }
        
        @Override
        public String getSerialNo() {
            return _serialNo;
        }
        
        @Override
        public String getSoftwareVersion() {
            return _softwareVersion;
        }
        
        @Override
        public Temperature getTemperature() {
            return _temperature;
        }
        
        @Override
        public org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.PlatformComponentState.Type getType() {
            return _type;
        }
        
        @Override
        public Uint32 getUsedPower() {
            return _usedPower;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = State.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return State.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return State.bindingToString(this);
        }
    }
}
