package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.top.components;
import com.google.common.base.MoreObjects;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifier;

/**
 * This class represents the key of {@link Component} class.
 *
 * @see Component
 *
 */
@Generated("mdsal-binding-generator")
public class ComponentKey
 implements Identifier<Component> {
    @java.io.Serial
    private static final long serialVersionUID = -3247383373556665855L;
    private final String _name;


    /**
     * Constructs an instance.
     *
     * @param _name the entity name
     * @throws NullPointerException if any of the arguments are null
     */
    public ComponentKey(@NonNull String _name) {
        this._name = CodeHelpers.requireKeyProp(_name, "name");
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public ComponentKey(ComponentKey source) {
        this._name = source._name;
    }


    /**
     * Return name, guaranteed to be non-null.
     *
     * @return {@code String} name, guaranteed to be non-null.
     */
    public @NonNull String getName() {
        return _name;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_name);
    }

    @Override
    public final boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ComponentKey)) {
            return false;
        }
        final ComponentKey other = (ComponentKey) obj;
        if (!Objects.equals(_name, other._name)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(ComponentKey.class);
        CodeHelpers.appendValue(helper, "name", _name);
        return helper.toString();
    }
}

