package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.properties.top.properties;
import com.google.common.base.MoreObjects;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifier;

/**
 * This class represents the key of {@link Property} class.
 *
 * @see Property
 *
 */
@Generated("mdsal-binding-generator")
public class PropertyKey
 implements Identifier<Property> {
    @java.io.Serial
    private static final long serialVersionUID = 5405122500089700882L;
    private final String _name;


    /**
     * Constructs an instance.
     *
     * @param _name the entity name
     * @throws NullPointerException if any of the arguments are null
     */
    public PropertyKey(@NonNull String _name) {
        this._name = CodeHelpers.requireKeyProp(_name, "name");
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public PropertyKey(PropertyKey source) {
        this._name = source._name;
    }


    /**
     * Return name, guaranteed to be non-null.
     *
     * @return {@code String} name, guaranteed to be non-null.
     */
    public @NonNull String getName() {
        return _name;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_name);
    }

    @Override
    public final boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PropertyKey)) {
            return false;
        }
        final PropertyKey other = (PropertyKey) obj;
        if (!Objects.equals(_name, other._name)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(PropertyKey.class);
        CodeHelpers.appendValue(helper, "name", _name);
        return helper.toString();
    }
}

