package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openconfig.types.rev190416;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Common grouping for percentage statistics. Values include the instantaneous, 
 * average, minimum, and maximum statistics. Statistics are computed and reported 
 * based on a moving time interval (e.g., the last 30s). If supported by the 
 * device, the time interval over which the statistics are computed, and the times 
 * at which the minimum and maximum values occurred, are also reported.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-types</b>
 * <pre>
 * grouping avg-min-max-instant-stats-pct {
 *   leaf instant {
 *     type oc-types:percentage;
 *   }
 *   leaf avg {
 *     type oc-types:percentage;
 *   }
 *   leaf min {
 *     type oc-types:percentage;
 *   }
 *   leaf max {
 *     type oc-types:percentage;
 *   }
 *   uses stat-interval-state;
 *   uses min-max-time;
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface AvgMinMaxInstantStatsPct
    extends
    DataObject,
    StatIntervalState,
    MinMaxTime
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("avg-min-max-instant-stats-pct");

    @Override
    Class<? extends AvgMinMaxInstantStatsPct> implementedInterface();
    
    /**
     * Return instant, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The instantaneous percentage value.
     *     </code>
     * </pre>
     *
     * @return {@code Percentage} instant, or {@code null} if it is not present.
     *
     */
    Percentage getInstant();
    
    /**
     * Return instant, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The instantaneous percentage value.
     *     </code>
     * </pre>
     *
     * @return {@code Percentage} instant, guaranteed to be non-null.
     * @throws NoSuchElementException if instant is not present
     *
     */
    default @NonNull Percentage requireInstant() {
        return CodeHelpers.require(getInstant(), "instant");
    }
    
    /**
     * Return avg, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The arithmetic mean value of the percentage measure of the statistic over the
     *         time interval.
     *     </code>
     * </pre>
     *
     * @return {@code Percentage} avg, or {@code null} if it is not present.
     *
     */
    Percentage getAvg();
    
    /**
     * Return avg, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The arithmetic mean value of the percentage measure of the statistic over the
     *         time interval.
     *     </code>
     * </pre>
     *
     * @return {@code Percentage} avg, guaranteed to be non-null.
     * @throws NoSuchElementException if avg is not present
     *
     */
    default @NonNull Percentage requireAvg() {
        return CodeHelpers.require(getAvg(), "avg");
    }
    
    /**
     * Return min, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The minimum value of the percentage measure of the statistic over the time
     *         interval.
     *     </code>
     * </pre>
     *
     * @return {@code Percentage} min, or {@code null} if it is not present.
     *
     */
    Percentage getMin();
    
    /**
     * Return min, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The minimum value of the percentage measure of the statistic over the time
     *         interval.
     *     </code>
     * </pre>
     *
     * @return {@code Percentage} min, guaranteed to be non-null.
     * @throws NoSuchElementException if min is not present
     *
     */
    default @NonNull Percentage requireMin() {
        return CodeHelpers.require(getMin(), "min");
    }
    
    /**
     * Return max, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The maximum value of the percentage measure of the statistic over the time
     *         interval.
     *     </code>
     * </pre>
     *
     * @return {@code Percentage} max, or {@code null} if it is not present.
     *
     */
    Percentage getMax();
    
    /**
     * Return max, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The maximum value of the percentage measure of the statistic over the time
     *         interval.
     *     </code>
     * </pre>
     *
     * @return {@code Percentage} max, guaranteed to be non-null.
     * @throws NoSuchElementException if max is not present
     *
     */
    default @NonNull Percentage requireMax() {
        return CodeHelpers.require(getMax(), "max");
    }

}

