package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813.debug.messages.top;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813.DebugMessagesTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813.debug.messages.top.debug.entries.DebugService;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813.debug.messages.top.debug.entries.DebugServiceKey;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Enclosing container for list of debugs to enable.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-messages</b>
 * <pre>
 * container debug-entries {
 *   list debug-service {
 *     key service;
 *     leaf service {
 *       type leafref {
 *         path ../config/service;
 *       }
 *     }
 *     container config {
 *       uses debug-messages-config;
 *     }
 *     container state {
 *       config false;
 *       uses debug-messages-config;
 *     }
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link DebugEntriesBuilder}.
 * @see DebugEntriesBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface DebugEntries
    extends
    ChildOf<DebugMessagesTop>,
    Augmentable<DebugEntries>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("debug-entries");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813.debug.messages.top.DebugEntries> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813.debug.messages.top.DebugEntries.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813.debug.messages.top.@NonNull DebugEntries obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getDebugService());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813.debug.messages.top.@NonNull DebugEntries thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813.debug.messages.top.DebugEntries other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813.debug.messages.top.DebugEntries.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getDebugService(), other.getDebugService())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813.debug.messages.top.@NonNull DebugEntries obj) {
        final var helper = MoreObjects.toStringHelper("DebugEntries");
        CodeHelpers.appendValue(helper, "debugService", obj.getDebugService());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return debugService, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         List of debugging entries.
     *     </code>
     * </pre>
     *
     * @return {@code Map<DebugServiceKey, DebugService>} debugService, or {@code null} if it is not present.
     *
     */
    @Nullable Map<DebugServiceKey, DebugService> getDebugService();
    
    /**
     * Return debugService, or an empty list if it is not present.
     *
     * @return {@code Map<DebugServiceKey, DebugService>} debugService, or an empty list if it is not present.
     *
     */
    default @NonNull Map<DebugServiceKey, DebugService> nonnullDebugService() {
        return CodeHelpers.nonnull(getDebugService());
    }

}

