package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813.messages.state.Message;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Operational state data for Syslog messages.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-messages</b>
 * <pre>
 * grouping messages-state {
 *   container message {
 *     oc-ext:telemetry-atomic;
 *     config false;
 *     leaf msg {
 *       type string;
 *     }
 *     leaf priority {
 *       type uint8;
 *     }
 *     leaf app-name {
 *       type string;
 *     }
 *     leaf procid {
 *       type string;
 *     }
 *     leaf msgid {
 *       type string;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface MessagesState
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("messages-state");

    @Override
    Class<? extends MessagesState> implementedInterface();
    
    /**
     * Return message, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Syslog messages the client is Subscribing to. This is all messages currently
     *         configured to be sent according to syslog-severity.
     *     </code>
     * </pre>
     *
     * @return {@code Message} message, or {@code null} if it is not present.
     *
     */
    Message getMessage();

}

