package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.rev210406.interfaces.top.interfaces._interface;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.rev210406.InterfaceCommonConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.rev210406.InterfaceCommonState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.rev210406.InterfaceCommonState.AdminStatus;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.rev210406.InterfaceCommonState.OperStatus;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.rev210406.InterfaceCountersState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.rev210406.InterfacePhysConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.rev210406._interface.counters.state.Counters;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openconfig.types.rev190416.Timeticks64;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.interfaces.rev180220.InterfaceType;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Class that builds {@link State} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     State createState(int fooXyzzy, int barBaz) {
 *         return new StateBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of State, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see State
 *
 */
@Generated("mdsal-binding-generator")
public class StateBuilder {

    private AdminStatus _adminStatus;
    private Counters _counters;
    private Boolean _cpu;
    private String _description;
    private Boolean _enabled;
    private Uint32 _ifindex;
    private Timeticks64 _lastChange;
    private Boolean _logical;
    private Boolean _loopbackMode;
    private Boolean _management;
    private Uint16 _mtu;
    private String _name;
    private OperStatus _operStatus;
    private InterfaceType _type;


    Map<Class<? extends Augmentation<State>>, Augmentation<State>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public StateBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link InterfacePhysConfig}.
     *
     * @param arg InterfacePhysConfig from which the builder should be initialized
     */
    public StateBuilder(InterfacePhysConfig arg) {
        this._name = arg.getName();
        this._type = arg.getType();
        this._mtu = arg.getMtu();
        this._loopbackMode = arg.getLoopbackMode();
        this._description = arg.getDescription();
        this._enabled = arg.getEnabled();
    }
    
    /**
     * Construct a new builder initialized from specified {@link InterfaceCommonConfig}.
     *
     * @param arg InterfaceCommonConfig from which the builder should be initialized
     */
    public StateBuilder(InterfaceCommonConfig arg) {
        this._description = arg.getDescription();
        this._enabled = arg.getEnabled();
    }
    
    
    /**
     * Construct a new builder initialized from specified {@link InterfaceCommonState}.
     *
     * @param arg InterfaceCommonState from which the builder should be initialized
     */
    public StateBuilder(InterfaceCommonState arg) {
        this._ifindex = arg.getIfindex();
        this._adminStatus = arg.getAdminStatus();
        this._operStatus = arg.getOperStatus();
        this._lastChange = arg.getLastChange();
        this._logical = arg.getLogical();
        this._management = arg.getManagement();
        this._cpu = arg.getCpu();
    }
    
    
    /**
     * Construct a new builder initialized from specified {@link InterfaceCountersState}.
     *
     * @param arg InterfaceCountersState from which the builder should be initialized
     */
    public StateBuilder(InterfaceCountersState arg) {
        this._counters = arg.getCounters();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link State}.
     *
     * @param base State from which the builder should be initialized
     */
    public StateBuilder(State base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._adminStatus = base.getAdminStatus();
        this._counters = base.getCounters();
        this._cpu = base.getCpu();
        this._description = base.getDescription();
        this._enabled = base.getEnabled();
        this._ifindex = base.getIfindex();
        this._lastChange = base.getLastChange();
        this._logical = base.getLogical();
        this._loopbackMode = base.getLoopbackMode();
        this._management = base.getManagement();
        this._mtu = base.getMtu();
        this._name = base.getName();
        this._operStatus = base.getOperStatus();
        this._type = base.getType();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link InterfaceCommonState}</li>
     *   <li>{@link InterfaceCommonConfig}</li>
     *   <li>{@link InterfaceCountersState}</li>
     *   <li>{@link InterfacePhysConfig}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof InterfaceCommonState castArg) {
            this._ifindex = castArg.getIfindex();
            this._adminStatus = castArg.getAdminStatus();
            this._operStatus = castArg.getOperStatus();
            this._lastChange = castArg.getLastChange();
            this._logical = castArg.getLogical();
            this._management = castArg.getManagement();
            this._cpu = castArg.getCpu();
            isValidArg = true;
        }
        if (arg instanceof InterfaceCommonConfig castArg) {
            this._description = castArg.getDescription();
            this._enabled = castArg.getEnabled();
            isValidArg = true;
        }
        if (arg instanceof InterfaceCountersState castArg) {
            this._counters = castArg.getCounters();
            isValidArg = true;
        }
        if (arg instanceof InterfacePhysConfig castArg) {
            this._name = castArg.getName();
            this._type = castArg.getType();
            this._mtu = castArg.getMtu();
            this._loopbackMode = castArg.getLoopbackMode();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[InterfaceCommonState, InterfaceCommonConfig, InterfaceCountersState, InterfacePhysConfig]");
    }

    /**
     * Return current value associated with the property corresponding to {@link State#getAdminStatus()}.
     *
     * @return current value
     */
    public AdminStatus getAdminStatus() {
        return _adminStatus;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getCounters()}.
     *
     * @return current value
     */
    public Counters getCounters() {
        return _counters;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getCpu()}.
     *
     * @return current value
     */
    public Boolean getCpu() {
        return _cpu;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getDescription()}.
     *
     * @return current value
     */
    public String getDescription() {
        return _description;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getEnabled()}.
     *
     * @return current value
     */
    public Boolean getEnabled() {
        return _enabled;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getIfindex()}.
     *
     * @return current value
     */
    public Uint32 getIfindex() {
        return _ifindex;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getLastChange()}.
     *
     * @return current value
     */
    public Timeticks64 getLastChange() {
        return _lastChange;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getLogical()}.
     *
     * @return current value
     */
    public Boolean getLogical() {
        return _logical;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getLoopbackMode()}.
     *
     * @return current value
     */
    public Boolean getLoopbackMode() {
        return _loopbackMode;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getManagement()}.
     *
     * @return current value
     */
    public Boolean getManagement() {
        return _management;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getMtu()}.
     *
     * @return current value
     */
    public Uint16 getMtu() {
        return _mtu;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getName()}.
     *
     * @return current value
     */
    public String getName() {
        return _name;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getOperStatus()}.
     *
     * @return current value
     */
    public OperStatus getOperStatus() {
        return _operStatus;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getType()}.
     *
     * @return current value
     */
    public InterfaceType getType() {
        return _type;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<State>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link State#getAdminStatus()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setAdminStatus(final AdminStatus value) {
        this._adminStatus = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getCounters()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setCounters(final Counters value) {
        this._counters = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getCpu()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setCpu(final Boolean value) {
        this._cpu = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getDescription()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setDescription(final String value) {
        this._description = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getEnabled()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setEnabled(final Boolean value) {
        this._enabled = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getIfindex()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setIfindex(final Uint32 value) {
        this._ifindex = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getLastChange()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setLastChange(final Timeticks64 value) {
        this._lastChange = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getLogical()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setLogical(final Boolean value) {
        this._logical = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getLoopbackMode()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setLoopbackMode(final Boolean value) {
        this._loopbackMode = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getManagement()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setManagement(final Boolean value) {
        this._management = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getMtu()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setMtu(final Uint16 value) {
        this._mtu = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getName()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setName(final String value) {
        this._name = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getOperStatus()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setOperStatus(final OperStatus value) {
        this._operStatus = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getType()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setType(final InterfaceType value) {
        this._type = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public StateBuilder addAugmentation(Augmentation<State> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public StateBuilder removeAugmentation(Class<? extends Augmentation<State>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link State} instance.
     *
     * @return A new {@link State} instance.
     */
    public @NonNull State build() {
        return new StateImpl(this);
    }

    private static final class StateImpl
        extends AbstractAugmentable<State>
        implements State {
    
        private final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.rev210406.InterfaceCommonState.AdminStatus _adminStatus;
        private final Counters _counters;
        private final Boolean _cpu;
        private final String _description;
        private final Boolean _enabled;
        private final Uint32 _ifindex;
        private final Timeticks64 _lastChange;
        private final Boolean _logical;
        private final Boolean _loopbackMode;
        private final Boolean _management;
        private final Uint16 _mtu;
        private final String _name;
        private final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.rev210406.InterfaceCommonState.OperStatus _operStatus;
        private final InterfaceType _type;
    
        StateImpl(StateBuilder base) {
            super(base.augmentation);
            this._adminStatus = base.getAdminStatus();
            this._counters = base.getCounters();
            this._cpu = base.getCpu();
            this._description = base.getDescription();
            this._enabled = base.getEnabled();
            this._ifindex = base.getIfindex();
            this._lastChange = base.getLastChange();
            this._logical = base.getLogical();
            this._loopbackMode = base.getLoopbackMode();
            this._management = base.getManagement();
            this._mtu = base.getMtu();
            this._name = base.getName();
            this._operStatus = base.getOperStatus();
            this._type = base.getType();
        }
    
        @Override
        public org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.rev210406.InterfaceCommonState.AdminStatus getAdminStatus() {
            return _adminStatus;
        }
        
        @Override
        public Counters getCounters() {
            return _counters;
        }
        
        @Override
        public Boolean getCpu() {
            return _cpu;
        }
        
        @Override
        public String getDescription() {
            return _description;
        }
        
        @Override
        public Boolean getEnabled() {
            return _enabled;
        }
        
        @Override
        public Uint32 getIfindex() {
            return _ifindex;
        }
        
        @Override
        public Timeticks64 getLastChange() {
            return _lastChange;
        }
        
        @Override
        public Boolean getLogical() {
            return _logical;
        }
        
        @Override
        public Boolean getLoopbackMode() {
            return _loopbackMode;
        }
        
        @Override
        public Boolean getManagement() {
            return _management;
        }
        
        @Override
        public Uint16 getMtu() {
            return _mtu;
        }
        
        @Override
        public String getName() {
            return _name;
        }
        
        @Override
        public org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.rev210406.InterfaceCommonState.OperStatus getOperStatus() {
            return _operStatus;
        }
        
        @Override
        public InterfaceType getType() {
            return _type;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = State.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return State.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return State.bindingToString(this);
        }
    }
}
