package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.yang.rev210302.MacAddress;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Enumeration;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Configuration items for Ethernet interfaces
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-if-ethernet</b>
 * <pre>
 * grouping ethernet-interface-config {
 *   leaf mac-address {
 *     type oc-yang:mac-address;
 *   }
 *   leaf auto-negotiate {
 *     type boolean;
 *     default true;
 *   }
 *   leaf standalone-link-training {
 *     type boolean;
 *     default false;
 *   }
 *   leaf duplex-mode {
 *     type enumeration {
 *       enum FULL {
 *       }
 *       enum HALF {
 *       }
 *     }
 *   }
 *   leaf port-speed {
 *     type identityref {
 *       base ETHERNET_SPEED;
 *     }
 *   }
 *   leaf enable-flow-control {
 *     type boolean;
 *     default false;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface EthernetInterfaceConfig
    extends
    DataObject
{


    /**
     *
     * <p>
     * This class represents the following YANG schema fragment defined in module <b>openconfig-if-ethernet</b>
     * <pre>
     * leaf duplex-mode {
     *   type enumeration {
     *     enum FULL {
     *     }
     *     enum HALF {
     *     }
     *   }
     * }
     * </pre>
     *
     */
    @Generated("mdsal-binding-generator")
    public enum DuplexMode implements Enumeration {
        /**
         * Full duplex mode
         */
        FULL(0, "FULL"),
        
        /**
         * Half duplex mode
         */
        HALF(1, "HALF")
        ;
    
        private final @NonNull String name;
        private final int value;
    
        private DuplexMode(int value, @NonNull String name) {
            this.value = value;
            this.name = name;
        }
    
        @Override
        public @NonNull String getName() {
            return name;
        }
    
        @Override
        public int getIntValue() {
            return value;
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified assigned name.
         *
         * @param name YANG assigned name
         * @return corresponding DuplexMode item, or {@code null} if no such item exists
         * @throws NullPointerException if {@code name} is null
         */
        public static @Nullable DuplexMode forName(String name) {
            return switch (name) {
                case "FULL" -> FULL;
                case "HALF" -> HALF;
                default -> null;
            };
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding DuplexMode item, or {@code null} if no such item exists
         */
        public static @Nullable DuplexMode forValue(int intValue) {
            return switch (intValue) {
                case 0 -> FULL;
                case 1 -> HALF;
                default -> null;
            };
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified assigned name.
         *
         * @param name YANG assigned name
         * @return corresponding DuplexMode item
         * @throws NullPointerException if {@code name} is null
         * @throws IllegalArgumentException if {@code name} does not match any item
         */
        public static @NonNull DuplexMode ofName(String name) {
            return CodeHelpers.checkEnum(forName(name), name);
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding DuplexMode item
         * @throws IllegalArgumentException if {@code intValue} does not match any item
         */
        public static @NonNull DuplexMode ofValue(int intValue) {
            return CodeHelpers.checkEnum(forValue(intValue), intValue);
        }
    }

    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("ethernet-interface-config");

    @Override
    Class<? extends EthernetInterfaceConfig> implementedInterface();
    
    /**
     * Return macAddress, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Assigns a MAC address to the Ethernet interface. If not specified, the
     *         corresponding operational state leaf is expected to show the system-assigned MAC
     *         address.
     *     </code>
     * </pre>
     *
     * @return {@code MacAddress} macAddress, or {@code null} if it is not present.
     *
     */
    MacAddress getMacAddress();
    
    /**
     * Return macAddress, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Assigns a MAC address to the Ethernet interface. If not specified, the
     *         corresponding operational state leaf is expected to show the system-assigned MAC
     *         address.
     *     </code>
     * </pre>
     *
     * @return {@code MacAddress} macAddress, guaranteed to be non-null.
     * @throws NoSuchElementException if macAddress is not present
     *
     */
    default @NonNull MacAddress requireMacAddress() {
        return CodeHelpers.require(getMacAddress(), "macaddress");
    }
    
    /**
     * Return autoNegotiate, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Set to TRUE to request the interface to auto-negotiate transmission parameters
     *         with its peer interface. When set to FALSE, the transmission parameters are
     *         specified manually.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} autoNegotiate, or {@code null} if it is not present.
     *
     */
    Boolean getAutoNegotiate();
    
    /**
     * Return autoNegotiate, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Set to TRUE to request the interface to auto-negotiate transmission parameters
     *         with its peer interface. When set to FALSE, the transmission parameters are
     *         specified manually.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} autoNegotiate, guaranteed to be non-null.
     * @throws NoSuchElementException if autoNegotiate is not present
     *
     */
    default @NonNull Boolean requireAutoNegotiate() {
        return CodeHelpers.require(getAutoNegotiate(), "autonegotiate");
    }
    
    /**
     * Return standaloneLinkTraining, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Link training is automatic tuning of the SerDes transmit and receive parameters
     *         to ensure an optimal connection over copper links. It is normally run as part of
     *         the auto negotiation sequence as specified in IEEE 802.3 Clause 73. Standalone
     *         link training is used when full auto negotiation is not desired on an Ethernet
     *         link but link training is needed. It is configured by setting the
     *         standalone-link-training leaf to TRUE and augo-negotiate leaf to FALSE. Note: If
     *         auto-negotiate is true, then the value of standalone link training leaf will be
     *         ignored.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} standaloneLinkTraining, or {@code null} if it is not present.
     *
     */
    Boolean getStandaloneLinkTraining();
    
    /**
     * Return standaloneLinkTraining, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Link training is automatic tuning of the SerDes transmit and receive parameters
     *         to ensure an optimal connection over copper links. It is normally run as part of
     *         the auto negotiation sequence as specified in IEEE 802.3 Clause 73. Standalone
     *         link training is used when full auto negotiation is not desired on an Ethernet
     *         link but link training is needed. It is configured by setting the
     *         standalone-link-training leaf to TRUE and augo-negotiate leaf to FALSE. Note: If
     *         auto-negotiate is true, then the value of standalone link training leaf will be
     *         ignored.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} standaloneLinkTraining, guaranteed to be non-null.
     * @throws NoSuchElementException if standaloneLinkTraining is not present
     *
     */
    default @NonNull Boolean requireStandaloneLinkTraining() {
        return CodeHelpers.require(getStandaloneLinkTraining(), "standalonelinktraining");
    }
    
    /**
     * Return duplexMode, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         When auto-negotiate is TRUE, this optionally sets the duplex mode that will be
     *         advertised to the peer. If unspecified, the interface should negotiate the
     *         duplex mode directly (typically full-duplex). When auto-negotiate is FALSE, this
     *         sets the duplex mode on the interface directly.
     *     </code>
     * </pre>
     *
     * @return {@code DuplexMode} duplexMode, or {@code null} if it is not present.
     *
     */
    DuplexMode getDuplexMode();
    
    /**
     * Return duplexMode, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         When auto-negotiate is TRUE, this optionally sets the duplex mode that will be
     *         advertised to the peer. If unspecified, the interface should negotiate the
     *         duplex mode directly (typically full-duplex). When auto-negotiate is FALSE, this
     *         sets the duplex mode on the interface directly.
     *     </code>
     * </pre>
     *
     * @return {@code DuplexMode} duplexMode, guaranteed to be non-null.
     * @throws NoSuchElementException if duplexMode is not present
     *
     */
    default @NonNull DuplexMode requireDuplexMode() {
        return CodeHelpers.require(getDuplexMode(), "duplexmode");
    }
    
    /**
     * Return portSpeed, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         When auto-negotiate is TRUE, this optionally sets the port-speed mode that will
     *         be advertised to the peer for negotiation. If unspecified, it is expected that
     *         the interface will select the highest speed available based on negotiation. When
     *         auto-negotiate is set to FALSE, sets the link speed to a fixed value --
     *         supported values are defined by ETHERNET_SPEED identities
     *     </code>
     * </pre>
     *
     * @return {@code ETHERNETSPEED} portSpeed, or {@code null} if it is not present.
     *
     */
    ETHERNETSPEED getPortSpeed();
    
    /**
     * Return portSpeed, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         When auto-negotiate is TRUE, this optionally sets the port-speed mode that will
     *         be advertised to the peer for negotiation. If unspecified, it is expected that
     *         the interface will select the highest speed available based on negotiation. When
     *         auto-negotiate is set to FALSE, sets the link speed to a fixed value --
     *         supported values are defined by ETHERNET_SPEED identities
     *     </code>
     * </pre>
     *
     * @return {@code ETHERNETSPEED} portSpeed, guaranteed to be non-null.
     * @throws NoSuchElementException if portSpeed is not present
     *
     */
    default @NonNull ETHERNETSPEED requirePortSpeed() {
        return CodeHelpers.require(getPortSpeed(), "portspeed");
    }
    
    /**
     * Return enableFlowControl, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Enable or disable flow control for this interface. Ethernet flow control is a
     *         mechanism by which a receiver may send PAUSE frames to a sender to stop
     *         transmission for a specified time. This setting should override auto-negotiated
     *         flow control settings. If left unspecified, and auto-negotiate is TRUE, flow
     *         control mode is negotiated with the peer interface.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} enableFlowControl, or {@code null} if it is not present.
     *
     */
    Boolean getEnableFlowControl();
    
    /**
     * Return enableFlowControl, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Enable or disable flow control for this interface. Ethernet flow control is a
     *         mechanism by which a receiver may send PAUSE frames to a sender to stop
     *         transmission for a specified time. This setting should override auto-negotiated
     *         flow control settings. If left unspecified, and auto-negotiate is TRUE, flow
     *         control mode is negotiated with the peer interface.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} enableFlowControl, guaranteed to be non-null.
     * @throws NoSuchElementException if enableFlowControl is not present
     *
     */
    default @NonNull Boolean requireEnableFlowControl() {
        return CodeHelpers.require(getEnableFlowControl(), "enableflowcontrol");
    }

}

