package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.types.rev181121;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Indicates the existence of a non-service affecting fault condition and that 
 * corrective action should be taken in order to prevent a more serious (for 
 * example, service affecting) fault. Such a severity can be reported, for 
 * when the detected alarm condition is not currently degrading the capacity of 
 * resource
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-alarm-types</b>
 * <pre>
 * identity MINOR {
 *   base OPENCONFIG_ALARM_SEVERITY;
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface MINOR
    extends
    OPENCONFIGALARMSEVERITY
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("MINOR");
    /**
     * Singleton value representing the {@link MINOR} identity.
     */
    public static final @NonNull MINOR VALUE = new MINOR() {
        @Override
        public Class<MINOR> implementedInterface() {
            return MINOR.class;
        }
    
        @Override
        public int hashCode() {
            return MINOR.class.hashCode();
        }
    
        @Override
        public boolean equals(final Object obj) {
            return obj == this || obj instanceof MINOR other
                && MINOR.class.equals(other.implementedInterface());
        }
    
        @Override
        public String toString() {
            return MoreObjects.toStringHelper("MINOR").add("qname", QNAME).toString();
        }
    };

    @Override
    Class<? extends MINOR> implementedInterface();

}

