package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.yang.binding.DataRoot;

/**
 * This module defines configuration and operational state data related to 
 * authorization, authentication, and accounting (AAA) management. Portions of 
 * model reuse data definitions or structure from RFC 7317 - A YANG Data Model for 
 * System Management
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-aaa</b>
 * <pre>
 * module openconfig-aaa {
 *   yang-version 1;
 *   namespace "http://openconfig.net/yang/aaa";
 *   prefix oc-aaa;
 *   import openconfig-extensions {
 *     prefix oc-ext;
 *   }
 *   import openconfig-inet-types {
 *     prefix oc-inet;
 *   }
 *   import openconfig-yang-types {
 *     prefix oc-yang;
 *   }
 *   import openconfig-aaa-types {
 *     prefix oc-aaa-types;
 *   }
 *   include openconfig-aaa-tacacs;
 *   include openconfig-aaa-radius;
 *   oc-ext:openconfig-version 0.5.0;
 *   revision 2020-07-30 {
 *   }
 *   revision 2019-10-28 {
 *   }
 *   revision 2019-08-20 {
 *   }
 *   revision 2018-11-21 {
 *   }
 *   revision 2018-04-12 {
 *   }
 *   revision 2017-09-18 {
 *   }
 *   revision 2017-07-06 {
 *   }
 *   revision 2017-01-29 {
 *   }
 *   oc-ext:regexp-posix;
 *   oc-ext:catalog-organization openconfig;
 *   oc-ext:origin openconfig;
 *   grouping aaa-servergroup-common-config {
 *     leaf name {
 *       type string;
 *     }
 *     leaf type {
 *       type identityref {
 *         base AAA_SERVER_TYPE;
 *       }
 *     }
 *   }
 *   grouping aaa-servergroup-common-state {
 *   }
 *   grouping aaa-servergroup-common-top {
 *     container server-groups {
 *       list server-group {
 *         key name;
 *         leaf name {
 *           type leafref {
 *             path ../config/name;
 *           }
 *         }
 *         container config {
 *           uses aaa-servergroup-common-config;
 *         }
 *         container state {
 *           config false;
 *           uses aaa-servergroup-common-config;
 *           uses aaa-servergroup-common-state;
 *         }
 *         uses aaa-server-top;
 *       }
 *     }
 *   }
 *   grouping aaa-server-config {
 *     leaf name {
 *       type string;
 *     }
 *     leaf address {
 *       type oc-inet:ip-address;
 *     }
 *     leaf timeout {
 *       type uint16;
 *       units seconds;
 *     }
 *   }
 *   grouping aaa-server-state {
 *     leaf connection-opens {
 *       type oc-yang:counter64;
 *     }
 *     leaf connection-closes {
 *       type oc-yang:counter64;
 *     }
 *     leaf connection-aborts {
 *       type oc-yang:counter64;
 *     }
 *     leaf connection-failures {
 *       type oc-yang:counter64;
 *     }
 *     leaf connection-timeouts {
 *       type oc-yang:counter64;
 *     }
 *     leaf messages-sent {
 *       type oc-yang:counter64;
 *     }
 *     leaf messages-received {
 *       type oc-yang:counter64;
 *     }
 *     leaf errors-received {
 *       type oc-yang:counter64;
 *     }
 *   }
 *   grouping aaa-server-top {
 *     container servers {
 *       list server {
 *         key address;
 *         leaf address {
 *           type leafref {
 *             path ../config/address;
 *           }
 *         }
 *         container config {
 *           uses aaa-server-config;
 *         }
 *         container state {
 *           config false;
 *           uses aaa-server-config;
 *           uses aaa-server-state;
 *         }
 *         uses aaa-tacacs-server-top {
 *           when "../../config/type = 'oc-aaa:TACACS'";
 *         }
 *         uses aaa-radius-server-top {
 *           when "../../config/type = 'oc-aaa:RADIUS'";
 *         }
 *       }
 *     }
 *   }
 *   grouping aaa-admin-config {
 *     leaf admin-password {
 *       type string;
 *       oc-ext:openconfig-hashed-value;
 *     }
 *     leaf admin-password-hashed {
 *       type oc-aaa-types:crypt-password-type;
 *     }
 *   }
 *   grouping aaa-admin-state {
 *     leaf admin-username {
 *       type string;
 *     }
 *   }
 *   grouping aaa-authentication-admin-top {
 *     container admin-user {
 *       container config {
 *         uses aaa-admin-config;
 *       }
 *       container state {
 *         config false;
 *         uses aaa-admin-config;
 *         uses aaa-admin-state;
 *       }
 *     }
 *   }
 *   grouping aaa-authentication-user-config {
 *     leaf username {
 *       type string;
 *     }
 *     leaf password {
 *       type string;
 *       oc-ext:openconfig-hashed-value;
 *     }
 *     leaf password-hashed {
 *       type oc-aaa-types:crypt-password-type;
 *     }
 *     leaf ssh-key {
 *       type string;
 *     }
 *     leaf role {
 *       type union {
 *         type string;
 *         type identityref {
 *           base SYSTEM_DEFINED_ROLES;
 *         }
 *       }
 *     }
 *   }
 *   grouping aaa-authentication-user-state {
 *   }
 *   grouping aaa-authentication-user-top {
 *     container users {
 *       list user {
 *         key username;
 *         leaf username {
 *           type leafref {
 *             path ../config/username;
 *           }
 *         }
 *         container config {
 *           uses aaa-authentication-user-config;
 *         }
 *         container state {
 *           config false;
 *           uses aaa-authentication-user-config;
 *           uses aaa-authentication-user-state;
 *         }
 *       }
 *     }
 *   }
 *   grouping aaa-accounting-methods-common {
 *     leaf-list accounting-method {
 *       type union {
 *         type identityref {
 *           base AAA_METHOD_TYPE;
 *         }
 *         type string;
 *       }
 *       ordered-by user;
 *     }
 *   }
 *   grouping aaa-accounting-events-config {
 *     leaf event-type {
 *       type identityref {
 *         base AAA_ACCOUNTING_EVENT_TYPE;
 *       }
 *     }
 *     leaf record {
 *       type enumeration {
 *         enum START_STOP {
 *         }
 *         enum STOP {
 *         }
 *       }
 *     }
 *   }
 *   grouping aaa-accounting-events-state {
 *   }
 *   grouping aaa-accounting-events-top {
 *     container events {
 *       list event {
 *         key event-type;
 *         leaf event-type {
 *           type leafref {
 *             path ../config/event-type;
 *           }
 *         }
 *         container config {
 *           uses aaa-accounting-events-config;
 *         }
 *         container state {
 *           config false;
 *           uses aaa-accounting-events-config;
 *           uses aaa-accounting-events-state;
 *         }
 *       }
 *     }
 *   }
 *   grouping aaa-accounting-config {
 *     uses aaa-accounting-methods-common;
 *   }
 *   grouping aaa-accounting-state {
 *   }
 *   grouping aaa-accounting-top {
 *     container accounting {
 *       container config {
 *         uses aaa-accounting-config;
 *       }
 *       container state {
 *         config false;
 *         uses aaa-accounting-config;
 *         uses aaa-accounting-state;
 *       }
 *       uses aaa-accounting-events-top;
 *     }
 *   }
 *   grouping aaa-authorization-methods-config {
 *     leaf-list authorization-method {
 *       type union {
 *         type identityref {
 *           base AAA_METHOD_TYPE;
 *         }
 *         type string;
 *       }
 *       ordered-by user;
 *     }
 *   }
 *   grouping aaa-authorization-events-config {
 *     leaf event-type {
 *       type identityref {
 *         base AAA_AUTHORIZATION_EVENT_TYPE;
 *       }
 *     }
 *   }
 *   grouping aaa-authorization-events-state {
 *   }
 *   grouping aaa-authorization-events-top {
 *     container events {
 *       list event {
 *         key event-type;
 *         leaf event-type {
 *           type leafref {
 *             path ../config/event-type;
 *           }
 *         }
 *         container config {
 *           uses aaa-authorization-events-config;
 *         }
 *         container state {
 *           config false;
 *           uses aaa-authorization-events-config;
 *           uses aaa-authorization-events-state;
 *         }
 *       }
 *     }
 *   }
 *   grouping aaa-authorization-config {
 *     uses aaa-authorization-methods-config;
 *   }
 *   grouping aaa-authorization-state {
 *   }
 *   grouping aaa-authorization-top {
 *     container authorization {
 *       container config {
 *         uses aaa-authorization-config;
 *       }
 *       container state {
 *         config false;
 *         uses aaa-authorization-config;
 *         uses aaa-authorization-state;
 *       }
 *       uses aaa-authorization-events-top;
 *     }
 *   }
 *   grouping aaa-authentication-config {
 *     leaf-list authentication-method {
 *       type union {
 *         type identityref {
 *           base AAA_METHOD_TYPE;
 *         }
 *         type string;
 *       }
 *       ordered-by user;
 *     }
 *   }
 *   grouping aaa-authentication-state {
 *   }
 *   grouping aaa-authentication-top {
 *     container authentication {
 *       container config {
 *         uses aaa-authentication-config;
 *       }
 *       container state {
 *         config false;
 *         uses aaa-authentication-config;
 *         uses aaa-authentication-state;
 *       }
 *       uses aaa-authentication-admin-top;
 *       uses aaa-authentication-user-top;
 *     }
 *   }
 *   grouping aaa-config {
 *   }
 *   grouping aaa-state {
 *   }
 *   grouping aaa-top {
 *     container aaa {
 *       container config {
 *         uses aaa-config;
 *       }
 *       container state {
 *         config false;
 *         uses aaa-config;
 *         uses aaa-state;
 *       }
 *       uses aaa-authentication-top;
 *       uses aaa-authorization-top;
 *       uses aaa-accounting-top;
 *       uses aaa-servergroup-common-top;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface OpenconfigAaaData
    extends
    DataRoot
{





}

