package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authentication.user.top.Users;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Top-level grouping for local users
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-aaa</b>
 * <pre>
 * grouping aaa-authentication-user-top {
 *   container users {
 *     list user {
 *       key username;
 *       leaf username {
 *         type leafref {
 *           path ../config/username;
 *         }
 *       }
 *       container config {
 *         uses aaa-authentication-user-config;
 *       }
 *       container state {
 *         config false;
 *         uses aaa-authentication-user-config;
 *         uses aaa-authentication-user-state;
 *       }
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface AaaAuthenticationUserTop
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("aaa-authentication-user-top");

    @Override
    Class<? extends AaaAuthenticationUserTop> implementedInterface();
    
    /**
     * Return users, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Enclosing container list of local users
     *     </code>
     * </pre>
     *
     * @return {@code Users} users, or {@code null} if it is not present.
     *
     */
    Users getUsers();

}

