package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.types.rev181121.AAAMETHODTYPE;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.TypeObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Configuration data for global authentication
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-aaa</b>
 * <pre>
 * grouping aaa-authentication-config {
 *   leaf-list authentication-method {
 *     type union {
 *       type identityref {
 *         base AAA_METHOD_TYPE;
 *       }
 *       type string;
 *     }
 *     ordered-by user;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface AaaAuthenticationConfig
    extends
    DataObject
{

    /**
     *
     * <p>
     * This class represents the following YANG schema fragment defined in module <b>openconfig-aaa</b>
     * <pre>
     * leaf-list authentication-method {
     *   type union {
     *     type identityref {
     *       base AAA_METHOD_TYPE;
     *     }
     *     type string;
     *   }
     *   ordered-by user;
     * }
     * </pre>
     *
     */
    public static final class AuthenticationMethod
     implements TypeObject, Serializable {
        @java.io.Serial
        private static final long serialVersionUID = 246745011290736609L;
        private final AAAMETHODTYPE _aAAMETHODTYPE;
        private final String _string;
    
    
        public AuthenticationMethod(AAAMETHODTYPE _aAAMETHODTYPE) {
            super();
            this._aAAMETHODTYPE = Objects.requireNonNull(_aAAMETHODTYPE);
            this._string = null;
        }
        
        public AuthenticationMethod(String _string) {
            super();
            this._string = Objects.requireNonNull(_string);
            this._aAAMETHODTYPE = null;
        }
        /**
         * Creates a copy from Source Object.
         *
         * @param source Source object
         */
        public AuthenticationMethod(AuthenticationMethod source) {
            this._aAAMETHODTYPE = source._aAAMETHODTYPE;
            this._string = source._string;
        }
        
        /**
         * Return a String representing the value of this union.
         *
         * @return String representation of this union's value.
         */
        public String stringValue() {
            if (_aAAMETHODTYPE != null) {
                return _aAAMETHODTYPE.implementedInterface().toString();
            }
            if (_string != null) {
                return _string;
            }
            throw new IllegalStateException("No value assigned");
        }
    
    
        public AAAMETHODTYPE getAAAMETHODTYPE() {
            return _aAAMETHODTYPE;
        }
        
        public String getString() {
            return _string;
        }
    
    
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_aAAMETHODTYPE);
            result = prime * result + Objects.hashCode(_string);
            return result;
        }
    
        @Override
        public final boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof AuthenticationMethod)) {
                return false;
            }
            final AuthenticationMethod other = (AuthenticationMethod) obj;
            if (!Objects.equals(_aAAMETHODTYPE, other._aAAMETHODTYPE)) {
                return false;
            }
            if (!Objects.equals(_string, other._string)) {
                return false;
            }
            return true;
        }
    
        @Override
        public String toString() {
            final var helper = MoreObjects.toStringHelper(AuthenticationMethod.class);
            CodeHelpers.appendValue(helper, "aAAMETHODTYPE", _aAAMETHODTYPE);
            CodeHelpers.appendValue(helper, "string", _string);
            return helper.toString();
        }
    }
    


    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("aaa-authentication-config");

    @Override
    Class<? extends AaaAuthenticationConfig> implementedInterface();
    
    /**
     * Return authenticationMethod, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Ordered list of authentication methods for users. This can be either a reference
     *         to a server group, or a well- defined designation in the AAA_METHOD_TYPE
     *         identity. If authentication fails with one method, the next defined method is
     *         tried -- failure of all methods results in the user being denied access.
     *     </code>
     * </pre>
     *
     * @return {@code List<AuthenticationMethod>} authenticationMethod, or {@code null} if it is not present.
     *
     */
    @Nullable List<AuthenticationMethod> getAuthenticationMethod();
    
    /**
     * Return authenticationMethod, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Ordered list of authentication methods for users. This can be either a reference
     *         to a server group, or a well- defined designation in the AAA_METHOD_TYPE
     *         identity. If authentication fails with one method, the next defined method is
     *         tried -- failure of all methods results in the user being denied access.
     *     </code>
     * </pre>
     *
     * @return {@code List<AuthenticationMethod>} authenticationMethod, guaranteed to be non-null.
     * @throws NoSuchElementException if authenticationMethod is not present
     *
     */
    default @NonNull List<AuthenticationMethod> requireAuthenticationMethod() {
        return CodeHelpers.require(getAuthenticationMethod(), "authenticationmethod");
    }

}

