/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.switched.top.switched.vlan;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.VlanSwitchedConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.switched.top.switched.vlan.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630.VlanId;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630.VlanModeType;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ConfigBuilder {
    private VlanId _accessVlan;
    private VlanModeType _interfaceMode;
    private VlanId _nativeVlan;
    private Set<VlanSwitchedConfig.TrunkVlans> _trunkVlans;
    Map<Class<? extends Augmentation<Config>>, Augmentation<Config>> augmentation = Map.of();

    public ConfigBuilder() {
    }

    public ConfigBuilder(VlanSwitchedConfig arg) {
        this._interfaceMode = arg.getInterfaceMode();
        this._nativeVlan = arg.getNativeVlan();
        this._accessVlan = arg.getAccessVlan();
        this._trunkVlans = arg.getTrunkVlans();
    }

    public ConfigBuilder(Config base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>(aug);
        }
        this._accessVlan = base.getAccessVlan();
        this._interfaceMode = base.getInterfaceMode();
        this._nativeVlan = base.getNativeVlan();
        this._trunkVlans = base.getTrunkVlans();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof VlanSwitchedConfig) {
            VlanSwitchedConfig castArg = (VlanSwitchedConfig)arg;
            this._interfaceMode = castArg.getInterfaceMode();
            this._nativeVlan = castArg.getNativeVlan();
            this._accessVlan = castArg.getAccessVlan();
            this._trunkVlans = castArg.getTrunkVlans();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[VlanSwitchedConfig]");
    }

    public VlanId getAccessVlan() {
        return this._accessVlan;
    }

    public VlanModeType getInterfaceMode() {
        return this._interfaceMode;
    }

    public VlanId getNativeVlan() {
        return this._nativeVlan;
    }

    public Set<VlanSwitchedConfig.TrunkVlans> getTrunkVlans() {
        return this._trunkVlans;
    }

    public <E$$ extends Augmentation<Config>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ConfigBuilder setAccessVlan(VlanId value) {
        this._accessVlan = value;
        return this;
    }

    public ConfigBuilder setInterfaceMode(VlanModeType value) {
        this._interfaceMode = value;
        return this;
    }

    public ConfigBuilder setNativeVlan(VlanId value) {
        this._nativeVlan = value;
        return this;
    }

    public ConfigBuilder setTrunkVlans(Set<VlanSwitchedConfig.TrunkVlans> values) {
        this._trunkVlans = values;
        return this;
    }

    public ConfigBuilder addAugmentation(Augmentation<Config> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public ConfigBuilder removeAugmentation(Class<? extends Augmentation<Config>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Config build() {
        return new ConfigImpl(this);
    }

    private static final class ConfigImpl
    extends AbstractAugmentable<Config>
    implements Config {
        private final VlanId _accessVlan;
        private final VlanModeType _interfaceMode;
        private final VlanId _nativeVlan;
        private final Set<VlanSwitchedConfig.TrunkVlans> _trunkVlans;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ConfigImpl(ConfigBuilder base) {
            super(base.augmentation);
            this._accessVlan = base.getAccessVlan();
            this._interfaceMode = base.getInterfaceMode();
            this._nativeVlan = base.getNativeVlan();
            this._trunkVlans = base.getTrunkVlans();
        }

        @Override
        public VlanId getAccessVlan() {
            return this._accessVlan;
        }

        @Override
        public VlanModeType getInterfaceMode() {
            return this._interfaceMode;
        }

        @Override
        public VlanId getNativeVlan() {
            return this._nativeVlan;
        }

        @Override
        public Set<VlanSwitchedConfig.TrunkVlans> getTrunkVlans() {
            return this._trunkVlans;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Config.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Config.bindingEquals(this, obj);
        }

        public String toString() {
            return Config.bindingToString(this);
        }
    }
}

