/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.match.top.match._double.tagged.inner.range;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.VlanLogicalDoubleTaggedInnerRangeConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.match.top.match._double.tagged.inner.range.State;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630.VlanId;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class StateBuilder {
    private VlanId _innerHighVlanId;
    private VlanId _innerLowVlanId;
    private Set<VlanId> _outerVlanId;
    Map<Class<? extends Augmentation<State>>, Augmentation<State>> augmentation = Map.of();

    public StateBuilder() {
    }

    public StateBuilder(VlanLogicalDoubleTaggedInnerRangeConfig arg) {
        this._innerLowVlanId = arg.getInnerLowVlanId();
        this._innerHighVlanId = arg.getInnerHighVlanId();
        this._outerVlanId = arg.getOuterVlanId();
    }

    public StateBuilder(State base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<State>>, Augmentation<State>>(aug);
        }
        this._innerHighVlanId = base.getInnerHighVlanId();
        this._innerLowVlanId = base.getInnerLowVlanId();
        this._outerVlanId = base.getOuterVlanId();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof VlanLogicalDoubleTaggedInnerRangeConfig) {
            VlanLogicalDoubleTaggedInnerRangeConfig castArg = (VlanLogicalDoubleTaggedInnerRangeConfig)arg;
            this._innerLowVlanId = castArg.getInnerLowVlanId();
            this._innerHighVlanId = castArg.getInnerHighVlanId();
            this._outerVlanId = castArg.getOuterVlanId();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[VlanLogicalDoubleTaggedInnerRangeConfig]");
    }

    public VlanId getInnerHighVlanId() {
        return this._innerHighVlanId;
    }

    public VlanId getInnerLowVlanId() {
        return this._innerLowVlanId;
    }

    public Set<VlanId> getOuterVlanId() {
        return this._outerVlanId;
    }

    public <E$$ extends Augmentation<State>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public StateBuilder setInnerHighVlanId(VlanId value) {
        this._innerHighVlanId = value;
        return this;
    }

    public StateBuilder setInnerLowVlanId(VlanId value) {
        this._innerLowVlanId = value;
        return this;
    }

    public StateBuilder setOuterVlanId(Set<VlanId> values) {
        this._outerVlanId = values;
        return this;
    }

    public StateBuilder addAugmentation(Augmentation<State> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<State>>, Augmentation<State>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public StateBuilder removeAugmentation(Class<? extends Augmentation<State>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull State build() {
        return new StateImpl(this);
    }

    private static final class StateImpl
    extends AbstractAugmentable<State>
    implements State {
        private final VlanId _innerHighVlanId;
        private final VlanId _innerLowVlanId;
        private final Set<VlanId> _outerVlanId;
        private int hash = 0;
        private volatile boolean hashValid = false;

        StateImpl(StateBuilder base) {
            super(base.augmentation);
            this._innerHighVlanId = base.getInnerHighVlanId();
            this._innerLowVlanId = base.getInnerLowVlanId();
            this._outerVlanId = base.getOuterVlanId();
        }

        @Override
        public VlanId getInnerHighVlanId() {
            return this._innerHighVlanId;
        }

        @Override
        public VlanId getInnerLowVlanId() {
            return this._innerLowVlanId;
        }

        @Override
        public Set<VlanId> getOuterVlanId() {
            return this._outerVlanId;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = State.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return State.bindingEquals(this, obj);
        }

        public String toString() {
            return State.bindingToString(this);
        }
    }
}

