package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Enumeration;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-vlan-types</b>
 * <pre>
 * typedef vlan-stack-action {
 *   type enumeration {
 *     enum PUSH {
 *     }
 *     enum POP {
 *     }
 *     enum SWAP {
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public enum VlanStackAction implements Enumeration {
    /**
     * Push a VLAN onto the VLAN stack.
     */
    PUSH(0, "PUSH"),
    
    /**
     * Pop a VLAN from the VLAN stack.
     */
    POP(1, "POP"),
    
    /**
     * Swap the VLAN at the top of the VLAN stack.
     */
    SWAP(2, "SWAP")
    ;

    private final @NonNull String name;
    private final int value;

    private VlanStackAction(int value, @NonNull String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public @NonNull String getName() {
        return name;
    }

    @Override
    public int getIntValue() {
        return value;
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified assigned name.
     *
     * @param name YANG assigned name
     * @return corresponding VlanStackAction item, or {@code null} if no such item exists
     * @throws NullPointerException if {@code name} is null
     */
    public static @Nullable VlanStackAction forName(String name) {
        return switch (name) {
            case "PUSH" -> PUSH;
            case "POP" -> POP;
            case "SWAP" -> SWAP;
            default -> null;
        };
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding VlanStackAction item, or {@code null} if no such item exists
     */
    public static @Nullable VlanStackAction forValue(int intValue) {
        return switch (intValue) {
            case 0 -> PUSH;
            case 1 -> POP;
            case 2 -> SWAP;
            default -> null;
        };
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified assigned name.
     *
     * @param name YANG assigned name
     * @return corresponding VlanStackAction item
     * @throws NullPointerException if {@code name} is null
     * @throws IllegalArgumentException if {@code name} does not match any item
     */
    public static @NonNull VlanStackAction ofName(String name) {
        return CodeHelpers.checkEnum(forName(name), name);
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding VlanStackAction item
     * @throws IllegalArgumentException if {@code intValue} does not match any item
     */
    public static @NonNull VlanStackAction ofValue(int intValue) {
        return CodeHelpers.checkEnum(forValue(intValue), intValue);
    }
}
