package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Enumeration;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-vlan-types</b>
 * <pre>
 * typedef vlan-mode-type {
 *   type enumeration {
 *     enum ACCESS {
 *     }
 *     enum TRUNK {
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public enum VlanModeType implements Enumeration {
    /**
     * Access mode VLAN interface (No 802.1q header)
     */
    ACCESS(0, "ACCESS"),
    
    /**
     * Trunk mode VLAN interface
     */
    TRUNK(1, "TRUNK")
    ;

    private final @NonNull String name;
    private final int value;

    private VlanModeType(int value, @NonNull String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public @NonNull String getName() {
        return name;
    }

    @Override
    public int getIntValue() {
        return value;
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified assigned name.
     *
     * @param name YANG assigned name
     * @return corresponding VlanModeType item, or {@code null} if no such item exists
     * @throws NullPointerException if {@code name} is null
     */
    public static @Nullable VlanModeType forName(String name) {
        return switch (name) {
            case "ACCESS" -> ACCESS;
            case "TRUNK" -> TRUNK;
            default -> null;
        };
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding VlanModeType item, or {@code null} if no such item exists
     */
    public static @Nullable VlanModeType forValue(int intValue) {
        return switch (intValue) {
            case 0 -> ACCESS;
            case 1 -> TRUNK;
            default -> null;
        };
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified assigned name.
     *
     * @param name YANG assigned name
     * @return corresponding VlanModeType item
     * @throws NullPointerException if {@code name} is null
     * @throws IllegalArgumentException if {@code name} does not match any item
     */
    public static @NonNull VlanModeType ofName(String name) {
        return CodeHelpers.checkEnum(forName(name), name);
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding VlanModeType item
     * @throws IllegalArgumentException if {@code intValue} does not match any item
     */
    public static @NonNull VlanModeType ofValue(int intValue) {
        return CodeHelpers.checkEnum(forValue(intValue), intValue);
    }
}
