package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.yang.rev210302;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.ScalarTypeObject;
import org.opendaylight.yangtools.yang.common.Uint64;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-yang-types</b>
 * <pre>
 * typedef counter64 {
 *   type uint64;
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public class Counter64
 implements ScalarTypeObject<Uint64>, Serializable {
    private static final long serialVersionUID = -1099590625836683370L;
    private final Uint64 _value;

    private static void check_valueRange(final long value) {
    }

    @ConstructorParameters("value")
    public Counter64(Uint64 _value) {
        if (_value != null) {
            check_valueRange(_value.longValue());
        }
        
        CodeHelpers.requireValue(_value);
    
        this._value = _value;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public Counter64(Counter64 source) {
        this._value = source._value;
    }

    public static Counter64 getDefaultInstance(final String defaultValue) {
        return new Counter64(Uint64.valueOf(defaultValue));
    }

    @Override
    public Uint64 getValue() {
        return _value;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_value);
    }

    @Override
    public final boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Counter64)) {
            return false;
        }
        final Counter64 other = (Counter64) obj;
        if (!Objects.equals(_value, other._value)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(Counter64.class);
        CodeHelpers.appendValue(helper, "value", _value);
        return helper.toString();
    }
}

