package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.ScalarTypeObject;
import org.opendaylight.yangtools.yang.common.Uint16;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-inet-types</b>
 * <pre>
 * typedef port-number {
 *   type uint16;
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public class PortNumber
 implements ScalarTypeObject<Uint16>, Serializable {
    private static final long serialVersionUID = -5341082755708920855L;
    private final Uint16 _value;

    private static void check_valueRange(final int value) {
    }

    @ConstructorParameters("value")
    public PortNumber(Uint16 _value) {
        if (_value != null) {
            check_valueRange(_value.intValue());
        }
        
        CodeHelpers.requireValue(_value);
    
        this._value = _value;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public PortNumber(PortNumber source) {
        this._value = source._value;
    }

    public static PortNumber getDefaultInstance(final String defaultValue) {
        return new PortNumber(Uint16.valueOf(defaultValue));
    }

    @Override
    public Uint16 getValue() {
        return _value;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_value);
    }

    @Override
    public final boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PortNumber)) {
            return false;
        }
        final PortNumber other = (PortNumber) obj;
        if (!Objects.equals(_value, other._value)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(PortNumber.class);
        CodeHelpers.appendValue(helper, "value", _value);
        return helper.toString();
    }
}

