package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.top.ntp;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemNtpConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemNtpState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.IpAddress;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.yang.rev210302.Counter64;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link State} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     State createState(int fooXyzzy, int barBaz) {
 *         return new StateBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of State, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see State
 *
 */
@Generated("mdsal-binding-generator")
public class StateBuilder {

    private Counter64 _authMismatch;
    private Boolean _enableNtpAuth;
    private Boolean _enabled;
    private IpAddress _ntpSourceAddress;


    Map<Class<? extends Augmentation<State>>, Augmentation<State>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public StateBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link SystemNtpConfig}.
     *
     * @param arg SystemNtpConfig from which the builder should be initialized
     */
    public StateBuilder(SystemNtpConfig arg) {
        this._enabled = arg.getEnabled();
        this._ntpSourceAddress = arg.getNtpSourceAddress();
        this._enableNtpAuth = arg.getEnableNtpAuth();
    }
    
    
    /**
     * Construct a new builder initialized from specified {@link SystemNtpState}.
     *
     * @param arg SystemNtpState from which the builder should be initialized
     */
    public StateBuilder(SystemNtpState arg) {
        this._authMismatch = arg.getAuthMismatch();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link State}.
     *
     * @param base State from which the builder should be initialized
     */
    public StateBuilder(State base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._authMismatch = base.getAuthMismatch();
        this._enableNtpAuth = base.getEnableNtpAuth();
        this._enabled = base.getEnabled();
        this._ntpSourceAddress = base.getNtpSourceAddress();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link SystemNtpState}</li>
     *   <li>{@link SystemNtpConfig}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof SystemNtpState castArg) {
            this._authMismatch = castArg.getAuthMismatch();
            isValidArg = true;
        }
        if (arg instanceof SystemNtpConfig castArg) {
            this._enabled = castArg.getEnabled();
            this._ntpSourceAddress = castArg.getNtpSourceAddress();
            this._enableNtpAuth = castArg.getEnableNtpAuth();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[SystemNtpState, SystemNtpConfig]");
    }

    /**
     * Return current value associated with the property corresponding to {@link State#getAuthMismatch()}.
     *
     * @return current value
     */
    public Counter64 getAuthMismatch() {
        return _authMismatch;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getEnableNtpAuth()}.
     *
     * @return current value
     */
    public Boolean getEnableNtpAuth() {
        return _enableNtpAuth;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getEnabled()}.
     *
     * @return current value
     */
    public Boolean getEnabled() {
        return _enabled;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getNtpSourceAddress()}.
     *
     * @return current value
     */
    public IpAddress getNtpSourceAddress() {
        return _ntpSourceAddress;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<State>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link State#getAuthMismatch()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setAuthMismatch(final Counter64 value) {
        this._authMismatch = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getEnableNtpAuth()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setEnableNtpAuth(final Boolean value) {
        this._enableNtpAuth = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getEnabled()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setEnabled(final Boolean value) {
        this._enabled = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getNtpSourceAddress()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setNtpSourceAddress(final IpAddress value) {
        this._ntpSourceAddress = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public StateBuilder addAugmentation(Augmentation<State> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public StateBuilder removeAugmentation(Class<? extends Augmentation<State>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link State} instance.
     *
     * @return A new {@link State} instance.
     */
    public @NonNull State build() {
        return new StateImpl(this);
    }

    private static final class StateImpl
        extends AbstractAugmentable<State>
        implements State {
    
        private final Counter64 _authMismatch;
        private final Boolean _enableNtpAuth;
        private final Boolean _enabled;
        private final IpAddress _ntpSourceAddress;
    
        StateImpl(StateBuilder base) {
            super(base.augmentation);
            this._authMismatch = base.getAuthMismatch();
            this._enableNtpAuth = base.getEnableNtpAuth();
            this._enabled = base.getEnabled();
            this._ntpSourceAddress = base.getNtpSourceAddress();
        }
    
        @Override
        public Counter64 getAuthMismatch() {
            return _authMismatch;
        }
        
        @Override
        public Boolean getEnableNtpAuth() {
            return _enableNtpAuth;
        }
        
        @Override
        public Boolean getEnabled() {
            return _enabled;
        }
        
        @Override
        public IpAddress getNtpSourceAddress() {
            return _ntpSourceAddress;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = State.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return State.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return State.bindingToString(this);
        }
    }
}
