package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openconfig.types.rev190416.Timeticks64;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.yang.rev210302.DateAndTime;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Global operational state data for the system
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system</b>
 * <pre>
 * grouping system-global-state {
 *   leaf current-datetime {
 *     type oc-yang:date-and-time;
 *   }
 *   leaf boot-time {
 *     type oc-types:timeticks64;
 *     units nanoseconds;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface SystemGlobalState
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("system-global-state");

    @Override
    Class<? extends SystemGlobalState> implementedInterface();
    
    /**
     * Return currentDatetime, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The current system date and time.
     *     </code>
     * </pre>
     *
     * @return {@code DateAndTime} currentDatetime, or {@code null} if it is not present.
     *
     */
    DateAndTime getCurrentDatetime();
    
    /**
     * Return currentDatetime, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The current system date and time.
     *     </code>
     * </pre>
     *
     * @return {@code DateAndTime} currentDatetime, guaranteed to be non-null.
     * @throws NoSuchElementException if currentDatetime is not present
     *
     */
    default @NonNull DateAndTime requireCurrentDatetime() {
        return CodeHelpers.require(getCurrentDatetime(), "currentdatetime");
    }
    
    /**
     * Return bootTime, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         This timestamp indicates the time that the system was last restarted. The value
     *         is the timestamp in nanoseconds relative to the Unix Epoch (Jan 1, 1970 00:00:00
     *         UTC).
     *     </code>
     * </pre>
     *
     * @return {@code Timeticks64} bootTime, or {@code null} if it is not present.
     *
     */
    Timeticks64 getBootTime();
    
    /**
     * Return bootTime, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         This timestamp indicates the time that the system was last restarted. The value
     *         is the timestamp in nanoseconds relative to the Unix Epoch (Jan 1, 1970 00:00:00
     *         UTC).
     *     </code>
     * </pre>
     *
     * @return {@code Timeticks64} bootTime, guaranteed to be non-null.
     * @throws NoSuchElementException if bootTime is not present
     *
     */
    default @NonNull Timeticks64 requireBootTime() {
        return CodeHelpers.require(getBootTime(), "boottime");
    }

}

