package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns._static.top.HostEntries;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Top-level grouping for static DNS host entries
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system</b>
 * <pre>
 * grouping system-dns-static-top {
 *   container host-entries {
 *     list host-entry {
 *       key hostname;
 *       leaf hostname {
 *         type leafref {
 *           path ../config/hostname;
 *         }
 *       }
 *       container config {
 *         uses system-dns-static-config;
 *       }
 *       container state {
 *         config false;
 *         uses system-dns-static-config;
 *         uses system-dns-static-state;
 *       }
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface SystemDnsStaticTop
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("system-dns-static-top");

    @Override
    Class<? extends SystemDnsStaticTop> implementedInterface();
    
    /**
     * Return hostEntries, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Enclosing container for list of static host entries
     *     </code>
     * </pre>
     *
     * @return {@code HostEntries} hostEntries, or {@code null} if it is not present.
     *
     */
    HostEntries getHostEntries();

}

