package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.selectors.top.selectors;
import com.google.common.base.MoreObjects;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.SYSLOGFACILITY;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.SyslogSeverity;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifier;

/**
 * This class represents the key of {@link Selector} class.
 *
 * @see Selector
 *
 */
@Generated("mdsal-binding-generator")
public class SelectorKey
 implements Identifier<Selector> {
    private static final long serialVersionUID = 5746707881106668469L;
    private final SYSLOGFACILITY _facility;
    private final SyslogSeverity _severity;


    /**
     * Constructs an instance.
     *
     * @param _facility the entity facility
     * @param _severity the entity severity
     * @throws NullPointerException if any of the arguments are null
     */
    public SelectorKey(@NonNull SYSLOGFACILITY _facility, @NonNull SyslogSeverity _severity) {
        this._facility = CodeHelpers.requireKeyProp(_facility, "facility");
        this._severity = CodeHelpers.requireKeyProp(_severity, "severity");
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public SelectorKey(SelectorKey source) {
        this._facility = source._facility;
        this._severity = source._severity;
    }


    /**
     * Return facility, guaranteed to be non-null.
     *
     * @return {@code SYSLOGFACILITY} facility, guaranteed to be non-null.
     */
    public @NonNull SYSLOGFACILITY getFacility() {
        return _facility;
    }
    
    /**
     * Return severity, guaranteed to be non-null.
     *
     * @return {@code SyslogSeverity} severity, guaranteed to be non-null.
     */
    public @NonNull SyslogSeverity getSeverity() {
        return _severity;
    }


    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(_facility);
        result = prime * result + Objects.hashCode(_severity);
        return result;
    }

    @Override
    public final boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SelectorKey)) {
            return false;
        }
        final SelectorKey other = (SelectorKey) obj;
        if (!Objects.equals(_facility, other._facility)) {
            return false;
        }
        if (!Objects.equals(_severity, other._severity)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(SelectorKey.class);
        CodeHelpers.appendValue(helper, "facility", _facility);
        CodeHelpers.appendValue(helper, "severity", _severity);
        return helper.toString();
    }
}

