package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.selectors.top.Selectors;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Top-level grouping for the logging selector list
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system-logging</b>
 * <pre>
 * grouping logging-selectors-top {
 *   container selectors {
 *     list selector {
 *       key "facility severity";
 *       leaf facility {
 *         type leafref {
 *           path ../config/facility;
 *         }
 *       }
 *       leaf severity {
 *         type leafref {
 *           path ../config/severity;
 *         }
 *       }
 *       container config {
 *         uses logging-selectors-config;
 *       }
 *       container state {
 *         config false;
 *         uses logging-selectors-config;
 *         uses logging-selectors-state;
 *       }
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface LoggingSelectorsTop
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("logging-selectors-top");

    @Override
    Class<? extends LoggingSelectorsTop> implementedInterface();
    
    /**
     * Return selectors, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Enclosing container 
     *     </code>
     * </pre>
     *
     * @return {@code Selectors} selectors, or {@code null} if it is not present.
     *
     */
    Selectors getSelectors();

}

