package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.subcomponent.ref.top.subcomponents;
import com.google.common.base.MoreObjects;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifier;

/**
 * This class represents the key of {@link Subcomponent} class.
 *
 * @see Subcomponent
 *
 */
@Generated("mdsal-binding-generator")
public class SubcomponentKey
 implements Identifier<Subcomponent> {
    private static final long serialVersionUID = -7706495639426787329L;
    private final Object _name;


    /**
     * Constructs an instance.
     *
     * @param _name the entity name
     * @throws NullPointerException if any of the arguments are null
     */
    public SubcomponentKey(@NonNull Object _name) {
        this._name = CodeHelpers.requireKeyProp(_name, "name");
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public SubcomponentKey(SubcomponentKey source) {
        this._name = source._name;
    }


    /**
     * Return name, guaranteed to be non-null.
     *
     * @return {@code Object} name, guaranteed to be non-null.
     */
    public @NonNull Object getName() {
        return _name;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_name);
    }

    @Override
    public final boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SubcomponentKey)) {
            return false;
        }
        final SubcomponentKey other = (SubcomponentKey) obj;
        if (!Objects.equals(_name, other._name)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(SubcomponentKey.class);
        CodeHelpers.appendValue(helper, "name", _name);
        return helper.toString();
    }
}

