package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.top.components.component;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.PlatformComponentConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.PlatformComponentMemoryState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.PlatformComponentPowerState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.PlatformComponentState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.PlatformComponentTempState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.top.components.Component;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Operational state data for each component
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-platform</b>
 * <pre>
 * container state {
 *   config false;
 *   uses platform-component-config;
 *   uses platform-component-state;
 *   uses platform-component-temp-state;
 *   uses platform-component-memory-state;
 *   uses platform-component-power-state;
 * }
 * </pre>
 * <p>To create instances of this class use {@link StateBuilder}.
 * @see StateBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface State
    extends
    ChildOf<Component>,
    Augmentable<State>,
    PlatformComponentConfig,
    PlatformComponentState,
    PlatformComponentTempState,
    PlatformComponentMemoryState,
    PlatformComponentPowerState
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("state");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.top.components.component.State> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.top.components.component.State.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.top.components.component.@NonNull State obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getAllocatedPower());
        result = prime * result + Objects.hashCode(obj.getDescription());
        result = prime * result + Objects.hashCode(obj.getEmpty());
        result = prime * result + Objects.hashCode(obj.getFirmwareVersion());
        result = prime * result + Objects.hashCode(obj.getHardwareVersion());
        result = prime * result + Objects.hashCode(obj.getId());
        result = prime * result + Objects.hashCode(obj.getLocation());
        result = prime * result + Objects.hashCode(obj.getMemory());
        result = prime * result + Objects.hashCode(obj.getMfgDate());
        result = prime * result + Objects.hashCode(obj.getMfgName());
        result = prime * result + Objects.hashCode(obj.getName());
        result = prime * result + Objects.hashCode(obj.getOperStatus());
        result = prime * result + Objects.hashCode(obj.getParent());
        result = prime * result + Objects.hashCode(obj.getPartNo());
        result = prime * result + Objects.hashCode(obj.getRemovable());
        result = prime * result + Objects.hashCode(obj.getSerialNo());
        result = prime * result + Objects.hashCode(obj.getSoftwareVersion());
        result = prime * result + Objects.hashCode(obj.getTemperature());
        result = prime * result + Objects.hashCode(obj.getType());
        result = prime * result + Objects.hashCode(obj.getUsedPower());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.top.components.component.@NonNull State thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.top.components.component.State other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.top.components.component.State.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getAllocatedPower(), other.getAllocatedPower())) {
            return false;
        }
        if (!Objects.equals(thisObj.getEmpty(), other.getEmpty())) {
            return false;
        }
        if (!Objects.equals(thisObj.getOperStatus(), other.getOperStatus())) {
            return false;
        }
        if (!Objects.equals(thisObj.getRemovable(), other.getRemovable())) {
            return false;
        }
        if (!Objects.equals(thisObj.getUsedPower(), other.getUsedPower())) {
            return false;
        }
        if (!Objects.equals(thisObj.getDescription(), other.getDescription())) {
            return false;
        }
        if (!Objects.equals(thisObj.getFirmwareVersion(), other.getFirmwareVersion())) {
            return false;
        }
        if (!Objects.equals(thisObj.getHardwareVersion(), other.getHardwareVersion())) {
            return false;
        }
        if (!Objects.equals(thisObj.getId(), other.getId())) {
            return false;
        }
        if (!Objects.equals(thisObj.getLocation(), other.getLocation())) {
            return false;
        }
        if (!Objects.equals(thisObj.getMfgDate(), other.getMfgDate())) {
            return false;
        }
        if (!Objects.equals(thisObj.getMfgName(), other.getMfgName())) {
            return false;
        }
        if (!Objects.equals(thisObj.getName(), other.getName())) {
            return false;
        }
        if (!Objects.equals(thisObj.getParent(), other.getParent())) {
            return false;
        }
        if (!Objects.equals(thisObj.getPartNo(), other.getPartNo())) {
            return false;
        }
        if (!Objects.equals(thisObj.getSerialNo(), other.getSerialNo())) {
            return false;
        }
        if (!Objects.equals(thisObj.getSoftwareVersion(), other.getSoftwareVersion())) {
            return false;
        }
        if (!Objects.equals(thisObj.getMemory(), other.getMemory())) {
            return false;
        }
        if (!Objects.equals(thisObj.getTemperature(), other.getTemperature())) {
            return false;
        }
        if (!Objects.equals(thisObj.getType(), other.getType())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.top.components.component.@NonNull State obj) {
        final var helper = MoreObjects.toStringHelper("State");
        CodeHelpers.appendValue(helper, "allocatedPower", obj.getAllocatedPower());
        CodeHelpers.appendValue(helper, "description", obj.getDescription());
        CodeHelpers.appendValue(helper, "empty", obj.getEmpty());
        CodeHelpers.appendValue(helper, "firmwareVersion", obj.getFirmwareVersion());
        CodeHelpers.appendValue(helper, "hardwareVersion", obj.getHardwareVersion());
        CodeHelpers.appendValue(helper, "id", obj.getId());
        CodeHelpers.appendValue(helper, "location", obj.getLocation());
        CodeHelpers.appendValue(helper, "memory", obj.getMemory());
        CodeHelpers.appendValue(helper, "mfgDate", obj.getMfgDate());
        CodeHelpers.appendValue(helper, "mfgName", obj.getMfgName());
        CodeHelpers.appendValue(helper, "name", obj.getName());
        CodeHelpers.appendValue(helper, "operStatus", obj.getOperStatus());
        CodeHelpers.appendValue(helper, "parent", obj.getParent());
        CodeHelpers.appendValue(helper, "partNo", obj.getPartNo());
        CodeHelpers.appendValue(helper, "removable", obj.getRemovable());
        CodeHelpers.appendValue(helper, "serialNo", obj.getSerialNo());
        CodeHelpers.appendValue(helper, "softwareVersion", obj.getSoftwareVersion());
        CodeHelpers.appendValue(helper, "temperature", obj.getTemperature());
        CodeHelpers.appendValue(helper, "type", obj.getType());
        CodeHelpers.appendValue(helper, "usedPower", obj.getUsedPower());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return parent, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Reference to the name of the parent component. Note that this reference must be
     *         kept synchronized with the corresponding subcomponent reference from the parent
     *         component.
     *     </code>
     * </pre>
     *
     * @return {@code String} parent, or {@code null} if it is not present.
     *
     */
    @Override
    String getParent();

}

