package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.TypeObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Configuration data for license
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-license</b>
 * <pre>
 * grouping license-config {
 *   leaf license-id {
 *     type string;
 *   }
 *   leaf license-data {
 *     type union {
 *       type binary;
 *       type string;
 *     }
 *   }
 *   leaf active {
 *     type boolean;
 *     default false;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface LicenseConfig
    extends
    DataObject
{

    /**
     *
     * <p>
     * This class represents the following YANG schema fragment defined in module <b>openconfig-license</b>
     * <pre>
     * leaf license-data {
     *   type union {
     *     type binary;
     *     type string;
     *   }
     * }
     * </pre>
     *
     */
    public static final class LicenseData
     implements TypeObject, Serializable {
        private static final long serialVersionUID = 8620642263735776498L;
        private final byte[] _binary;
        private final String _string;
    
    
        public LicenseData(byte[] _binary) {
            super();
            this._binary = Objects.requireNonNull(_binary);
            this._string = null;
        }
        
        public LicenseData(String _string) {
            super();
            this._string = Objects.requireNonNull(_string);
            this._binary = null;
        }
        /**
         * Creates a copy from Source Object.
         *
         * @param source Source object
         */
        public LicenseData(LicenseData source) {
            this._binary = source._binary == null ? null : source._binary.clone();
            this._string = source._string;
        }
        
        /**
         * Return a String representing the value of this union.
         *
         * @return String representation of this union's value.
         */
        public String stringValue() {
            if (_binary != null) {
                return new String(_binary);
            }
            if (_string != null) {
                return _string;
            }
            throw new IllegalStateException("No value assigned");
        }
    
    
        public byte[] getBinary() {
            return _binary == null ? null : _binary.clone();
        }
        
        public String getString() {
            return _string;
        }
    
    
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + Arrays.hashCode(_binary);
            result = prime * result + Objects.hashCode(_string);
            return result;
        }
    
        @Override
        public final boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof LicenseData)) {
                return false;
            }
            final LicenseData other = (LicenseData) obj;
            if (!Arrays.equals(_binary, other._binary)) {
                return false;
            }
            if (!Objects.equals(_string, other._string)) {
                return false;
            }
            return true;
        }
    
        @Override
        public String toString() {
            final var helper = MoreObjects.toStringHelper(LicenseData.class);
            CodeHelpers.appendValue(helper, "binary", _binary);
            CodeHelpers.appendValue(helper, "string", _string);
            return helper.toString();
        }
    }
    


    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("license-config");

    @Override
    Class<? extends LicenseConfig> implementedInterface();
    
    /**
     * Return licenseId, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         License ID. A string that uniquelly identifies the license. The platform should
     *         list all the licenses it supports being activated.
     *     </code>
     * </pre>
     *
     * @return {@code String} licenseId, or {@code null} if it is not present.
     *
     */
    String getLicenseId();
    
    /**
     * Return licenseId, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         License ID. A string that uniquelly identifies the license. The platform should
     *         list all the licenses it supports being activated.
     *     </code>
     * </pre>
     *
     * @return {@code String} licenseId, guaranteed to be non-null.
     * @throws NoSuchElementException if licenseId is not present
     *
     */
    default @NonNull String requireLicenseId() {
        return CodeHelpers.require(getLicenseId(), "licenseid");
    }
    
    /**
     * Return licenseData, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The contents of the licence (if required) - which may be supplied as a binary
     *         blob, or a simple string value. If this value is considered sensitive, it may be
     *         read as an empty value.
     *     </code>
     * </pre>
     *
     * @return {@code LicenseData} licenseData, or {@code null} if it is not present.
     *
     */
    LicenseData getLicenseData();
    
    /**
     * Return licenseData, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The contents of the licence (if required) - which may be supplied as a binary
     *         blob, or a simple string value. If this value is considered sensitive, it may be
     *         read as an empty value.
     *     </code>
     * </pre>
     *
     * @return {@code LicenseData} licenseData, guaranteed to be non-null.
     * @throws NoSuchElementException if licenseData is not present
     *
     */
    default @NonNull LicenseData requireLicenseData() {
        return CodeHelpers.require(getLicenseData(), "licensedata");
    }
    
    /**
     * Return active, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The activation state of the license.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} active, or {@code null} if it is not present.
     *
     */
    Boolean getActive();
    
    /**
     * Return active, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The activation state of the license.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} active, guaranteed to be non-null.
     * @throws NoSuchElementException if active is not present
     *
     */
    default @NonNull Boolean requireActive() {
        return CodeHelpers.require(getActive(), "active");
    }

}

