package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.aggregate.rev200501;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.yang.binding.DataRoot;

/**
 * Model for managing aggregated (aka bundle, LAG) interfaces.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-if-aggregate</b>
 * <pre>
 * module openconfig-if-aggregate {
 *   yang-version 1;
 *   namespace "http://openconfig.net/yang/interfaces/aggregate";
 *   prefix oc-lag;
 *   import openconfig-interfaces {
 *     prefix oc-if;
 *   }
 *   import openconfig-if-ethernet {
 *     prefix oc-eth;
 *   }
 *   import iana-if-type {
 *     prefix ianaift;
 *   }
 *   import openconfig-if-types {
 *     prefix oc-ift;
 *   }
 *   import openconfig-extensions {
 *     prefix oc-ext;
 *   }
 *   oc-ext:openconfig-version 2.4.3;
 *   revision 2020-05-01 {
 *   }
 *   revision 2019-04-16 {
 *   }
 *   revision 2018-11-21 {
 *   }
 *   revision 2018-03-23 {
 *   }
 *   revision 2018-01-05 {
 *   }
 *   revision 2017-12-22 {
 *   }
 *   revision 2017-12-21 {
 *   }
 *   revision 2017-07-14 {
 *   }
 *   revision 2016-12-22 {
 *   }
 *   oc-ext:regexp-posix;
 *   oc-ext:catalog-organization openconfig;
 *   oc-ext:origin openconfig;
 *   typedef aggregation-type {
 *     type enumeration {
 *       enum LACP {
 *       }
 *       enum STATIC {
 *       }
 *     }
 *   }
 *   grouping aggregation-logical-config {
 *     leaf lag-type {
 *       type aggregation-type;
 *     }
 *     leaf min-links {
 *       type uint16;
 *     }
 *   }
 *   grouping aggregation-logical-state {
 *     leaf lag-speed {
 *       type uint32;
 *       units Mbps;
 *     }
 *     leaf-list member {
 *       when "../../config/lag-type = 'STATIC'" {
 *       }
 *       type oc-if:base-interface-ref;
 *     }
 *   }
 *   grouping aggregation-logical-top {
 *     container aggregation {
 *       container config {
 *         uses aggregation-logical-config;
 *       }
 *       container state {
 *         config false;
 *         uses aggregation-logical-config;
 *         uses aggregation-logical-state;
 *       }
 *     }
 *   }
 *   grouping ethernet-if-aggregation-config {
 *     leaf aggregate-id {
 *       type leafref {
 *         path /oc-if:interfaces/oc-if:interface/oc-if:name;
 *       }
 *     }
 *   }
 *   augment /oc-if:interfaces/oc-if:interface {
 *     uses aggregation-logical-top {
 *       when "oc-if:config/oc-if:type = 'ianaift:ieee8023adLag' or oc-if:config/oc-if:type = 'oc-ift:IF_AGGREGATE'" {
 *       }
 *     }
 *   }
 *   augment /oc-if:interfaces/oc-if:interface/oc-eth:ethernet/oc-eth:config {
 *     uses ethernet-if-aggregation-config;
 *   }
 *   augment /oc-if:interfaces/oc-if:interface/oc-eth:ethernet/oc-eth:state {
 *     uses ethernet-if-aggregation-config;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface OpenconfigIfAggregateData
    extends
    DataRoot
{





}

