package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.aggregate.rev200501;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Enumeration;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-if-aggregate</b>
 * <pre>
 * typedef aggregation-type {
 *   type enumeration {
 *     enum LACP {
 *     }
 *     enum STATIC {
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public enum AggregationType implements Enumeration {
    /**
     * LAG managed by LACP
     */
    LACP(0, "LACP"),
    
    /**
     * Statically configured bundle / LAG
     */
    STATIC(1, "STATIC")
    ;

    private final @NonNull String name;
    private final int value;

    private AggregationType(int value, @NonNull String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public @NonNull String getName() {
        return name;
    }

    @Override
    public int getIntValue() {
        return value;
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified assigned name.
     *
     * @param name YANG assigned name
     * @return corresponding AggregationType item, or {@code null} if no such item exists
     * @throws NullPointerException if {@code name} is null
     */
    public static @Nullable AggregationType forName(String name) {
        return switch (name) {
            case "LACP" -> LACP;
            case "STATIC" -> STATIC;
            default -> null;
        };
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding AggregationType item, or {@code null} if no such item exists
     */
    public static @Nullable AggregationType forValue(int intValue) {
        return switch (intValue) {
            case 0 -> LACP;
            case 1 -> STATIC;
            default -> null;
        };
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified assigned name.
     *
     * @param name YANG assigned name
     * @return corresponding AggregationType item
     * @throws NullPointerException if {@code name} is null
     * @throws IllegalArgumentException if {@code name} does not match any item
     */
    public static @NonNull AggregationType ofName(String name) {
        return CodeHelpers.checkEnum(forName(name), name);
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding AggregationType item
     * @throws IllegalArgumentException if {@code intValue} does not match any item
     */
    public static @NonNull AggregationType ofValue(int intValue) {
        return CodeHelpers.checkEnum(forValue(intValue), intValue);
    }
}
