package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authorization.events.top.events;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authorization.events.top.Events;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authorization.events.top.events.event.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authorization.events.top.events.event.State;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.types.rev181121.AAAAUTHORIZATIONEVENTTYPE;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * List of events subject to AAA authorization
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-aaa</b>
 * <pre>
 * list event {
 *   key event-type;
 *   leaf event-type {
 *     type leafref {
 *       path ../config/event-type;
 *     }
 *   }
 *   container config {
 *     uses aaa-authorization-events-config;
 *   }
 *   container state {
 *     config false;
 *     uses aaa-authorization-events-config;
 *     uses aaa-authorization-events-state;
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link EventBuilder}.
 * @see EventBuilder
 * @see EventKey
 *
 */
@Generated("mdsal-binding-generator")
public interface Event
    extends
    ChildOf<Events>,
    Augmentable<Event>,
    Identifiable<EventKey>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("event");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authorization.events.top.events.Event> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authorization.events.top.events.Event.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authorization.events.top.events.@NonNull Event obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getConfig());
        result = prime * result + Objects.hashCode(obj.getEventType());
        result = prime * result + Objects.hashCode(obj.getState());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authorization.events.top.events.@NonNull Event thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authorization.events.top.events.Event other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authorization.events.top.events.Event.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getEventType(), other.getEventType())) {
            return false;
        }
        if (!Objects.equals(thisObj.getConfig(), other.getConfig())) {
            return false;
        }
        if (!Objects.equals(thisObj.getState(), other.getState())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authorization.events.top.events.@NonNull Event obj) {
        final var helper = MoreObjects.toStringHelper("Event");
        CodeHelpers.appendValue(helper, "config", obj.getConfig());
        CodeHelpers.appendValue(helper, "eventType", obj.getEventType());
        CodeHelpers.appendValue(helper, "state", obj.getState());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    @Override
    EventKey key();
    
    /**
     * Return eventType, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Reference to the event-type list key
     *     </code>
     * </pre>
     *
     * @return {@code AAAAUTHORIZATIONEVENTTYPE} eventType, or {@code null} if it is not present.
     *
     */
    AAAAUTHORIZATIONEVENTTYPE getEventType();
    
    /**
     * Return eventType, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Reference to the event-type list key
     *     </code>
     * </pre>
     *
     * @return {@code AAAAUTHORIZATIONEVENTTYPE} eventType, guaranteed to be non-null.
     * @throws NoSuchElementException if eventType is not present
     *
     */
    default @NonNull AAAAUTHORIZATIONEVENTTYPE requireEventType() {
        return CodeHelpers.require(getEventType(), "eventtype");
    }
    
    /**
     * Return config, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Configuration data for each authorized event
     *     </code>
     * </pre>
     *
     * @return {@code Config} config, or {@code null} if it is not present.
     *
     */
    Config getConfig();
    
    /**
     * Return state, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Operational state data for each authorized activity
     *     </code>
     * </pre>
     *
     * @return {@code State} state, or {@code null} if it is not present.
     *
     */
    State getState();

}

