package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.server.top.Servers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Top-level grouping for list of AAA servers
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-aaa</b>
 * <pre>
 * grouping aaa-server-top {
 *   container servers {
 *     list server {
 *       key address;
 *       leaf address {
 *         type leafref {
 *           path ../config/address;
 *         }
 *       }
 *       container config {
 *         uses aaa-server-config;
 *       }
 *       container state {
 *         config false;
 *         uses aaa-server-config;
 *         uses aaa-server-state;
 *       }
 *       uses aaa-tacacs-server-top {
 *         when "../../config/type = 'oc-aaa:TACACS'";
 *       }
 *       uses aaa-radius-server-top {
 *         when "../../config/type = 'oc-aaa:RADIUS'";
 *       }
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface AaaServerTop
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("aaa-server-top");

    @Override
    Class<? extends AaaServerTop> implementedInterface();
    
    /**
     * Return servers, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Enclosing container the list of servers
     *     </code>
     * </pre>
     *
     * @return {@code Servers} servers, or {@code null} if it is not present.
     *
     */
    Servers getServers();

}

