/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.top.vlans.vlan;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.VlanConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.VlanState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.top.vlans.vlan.State;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630.VlanId;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class StateBuilder {
    private String _name;
    private VlanConfig.Status _status;
    private VlanId _vlanId;
    Map<Class<? extends Augmentation<State>>, Augmentation<State>> augmentation = Map.of();

    public StateBuilder() {
    }

    public StateBuilder(VlanConfig arg) {
        this._vlanId = arg.getVlanId();
        this._name = arg.getName();
        this._status = arg.getStatus();
    }

    public StateBuilder(VlanState arg) {
    }

    public StateBuilder(State base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<State>>, Augmentation<State>>(aug);
        }
        this._name = base.getName();
        this._status = base.getStatus();
        this._vlanId = base.getVlanId();
    }

    public void fieldsFrom(DataObject arg) {
        Object castArg;
        boolean isValidArg = false;
        if (arg instanceof VlanState) {
            castArg = (VlanState)arg;
            isValidArg = true;
        }
        if (arg instanceof VlanConfig) {
            castArg = (VlanConfig)arg;
            this._vlanId = castArg.getVlanId();
            this._name = castArg.getName();
            this._status = castArg.getStatus();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[VlanState, VlanConfig]");
    }

    public String getName() {
        return this._name;
    }

    public VlanConfig.Status getStatus() {
        return this._status;
    }

    public VlanId getVlanId() {
        return this._vlanId;
    }

    public <E$$ extends Augmentation<State>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public StateBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public StateBuilder setStatus(VlanConfig.Status value) {
        this._status = value;
        return this;
    }

    public StateBuilder setVlanId(VlanId value) {
        this._vlanId = value;
        return this;
    }

    public StateBuilder addAugmentation(Augmentation<State> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<State>>, Augmentation<State>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public StateBuilder removeAugmentation(Class<? extends Augmentation<State>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull State build() {
        return new StateImpl(this);
    }

    private static final class StateImpl
    extends AbstractAugmentable<State>
    implements State {
        private final String _name;
        private final VlanConfig.Status _status;
        private final VlanId _vlanId;
        private int hash = 0;
        private volatile boolean hashValid = false;

        StateImpl(StateBuilder base) {
            super(base.augmentation);
            this._name = base.getName();
            this._status = base.getStatus();
            this._vlanId = base.getVlanId();
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public VlanConfig.Status getStatus() {
            return this._status;
        }

        @Override
        public VlanId getVlanId() {
            return this._vlanId;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = State.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return State.bindingEquals(this, obj);
        }

        public String toString() {
            return State.bindingToString(this);
        }
    }
}

