/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Enumeration;

public enum IpVersion implements Enumeration
{
    UNKNOWN(0, "UNKNOWN"),
    IPV4(4, "IPV4"),
    IPV6(6, "IPV6");

    private final @NonNull String name;
    private final int value;

    private IpVersion(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public @NonNull String getName() {
        return this.name;
    }

    public int getIntValue() {
        return this.value;
    }

    public static @Nullable IpVersion forName(String name) {
        return switch (name) {
            case "UNKNOWN" -> UNKNOWN;
            case "IPV4" -> IPV4;
            case "IPV6" -> IPV6;
            default -> null;
        };
    }

    public static @Nullable IpVersion forValue(int intValue) {
        return switch (intValue) {
            case 0 -> UNKNOWN;
            case 4 -> IPV4;
            case 6 -> IPV6;
            default -> null;
        };
    }

    public static @NonNull IpVersion ofName(String name) {
        return (IpVersion)CodeHelpers.checkEnum((Enumeration)IpVersion.forName(name), (String)name);
    }

    public static @NonNull IpVersion ofValue(int intValue) {
        return (IpVersion)CodeHelpers.checkEnum((Enumeration)IpVersion.forValue(intValue), (int)intValue);
    }
}

