/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.ScalarTypeObject;

public class DomainName
implements ScalarTypeObject<String>,
Serializable {
    private static final long serialVersionUID = -7890312374818160504L;
    public static final List<String> PATTERN_CONSTANTS = ImmutableList.of((Object)"^(?:(((([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.)*([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.?)|\\.))$");
    private static final Pattern patterns = Pattern.compile(PATTERN_CONSTANTS.get(0));
    private static final String regexes = "(((([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.)*([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.?)|\\.)";
    private final String _value;

    private static void check_valueLength(String value) {
        int length = value.codePointCount(0, value.length());
        if (length >= 1 && length <= 253) {
            return;
        }
        CodeHelpers.throwInvalidLength((String)"[[1..253]]", (Object)value);
    }

    @ConstructorParameters(value={"value"})
    public DomainName(String _value) {
        if (_value != null) {
            DomainName.check_valueLength(_value);
        }
        CodeHelpers.requireValue((Object)_value);
        CodeHelpers.checkPattern((String)_value, (Pattern)patterns, (String)regexes);
        this._value = _value;
    }

    public DomainName(DomainName source) {
        this._value = source._value;
    }

    public static DomainName getDefaultInstance(String defaultValue) {
        return new DomainName(defaultValue);
    }

    public String getValue() {
        return this._value;
    }

    public int hashCode() {
        return CodeHelpers.wrapperHashCode((Object)this._value);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DomainName)) {
            return false;
        }
        DomainName other = (DomainName)obj;
        return Objects.equals(this._value, other._value);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(DomainName.class);
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"value", (Object)this._value);
        return helper.toString();
    }
}

