/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.memory.top.memory;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemMemoryConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemMemoryState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.memory.top.memory.State;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint64;

public class StateBuilder {
    private Uint64 _physical;
    private Uint64 _reserved;
    Map<Class<? extends Augmentation<State>>, Augmentation<State>> augmentation = Map.of();

    public StateBuilder() {
    }

    public StateBuilder(SystemMemoryConfig arg) {
    }

    public StateBuilder(SystemMemoryState arg) {
        this._physical = arg.getPhysical();
        this._reserved = arg.getReserved();
    }

    public StateBuilder(State base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<State>>, Augmentation<State>>(aug);
        }
        this._physical = base.getPhysical();
        this._reserved = base.getReserved();
    }

    public void fieldsFrom(DataObject arg) {
        Object castArg;
        boolean isValidArg = false;
        if (arg instanceof SystemMemoryState) {
            castArg = (SystemMemoryState)arg;
            this._physical = castArg.getPhysical();
            this._reserved = castArg.getReserved();
            isValidArg = true;
        }
        if (arg instanceof SystemMemoryConfig) {
            castArg = (SystemMemoryConfig)arg;
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[SystemMemoryState, SystemMemoryConfig]");
    }

    public Uint64 getPhysical() {
        return this._physical;
    }

    public Uint64 getReserved() {
        return this._reserved;
    }

    public <E$$ extends Augmentation<State>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public StateBuilder setPhysical(Uint64 value) {
        this._physical = value;
        return this;
    }

    public StateBuilder setReserved(Uint64 value) {
        this._reserved = value;
        return this;
    }

    public StateBuilder addAugmentation(Augmentation<State> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<State>>, Augmentation<State>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public StateBuilder removeAugmentation(Class<? extends Augmentation<State>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull State build() {
        return new StateImpl(this);
    }

    private static final class StateImpl
    extends AbstractAugmentable<State>
    implements State {
        private final Uint64 _physical;
        private final Uint64 _reserved;
        private int hash = 0;
        private volatile boolean hashValid = false;

        StateImpl(StateBuilder base) {
            super(base.augmentation);
            this._physical = base.getPhysical();
            this._reserved = base.getReserved();
        }

        @Override
        public Uint64 getPhysical() {
            return this._physical;
        }

        @Override
        public Uint64 getReserved() {
            return this._reserved;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = State.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return State.bindingEquals(this, obj);
        }

        public String toString() {
            return State.bindingToString(this);
        }
    }
}

