/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.selectors.top.selectors;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.SYSLOGFACILITY;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.SyslogSeverity;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.selectors.top.selectors.Selector;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.selectors.top.selectors.SelectorKey;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.selectors.top.selectors.selector.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.selectors.top.selectors.selector.State;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class SelectorBuilder {
    private Config _config;
    private SYSLOGFACILITY _facility;
    private SyslogSeverity _severity;
    private State _state;
    private SelectorKey key;
    Map<Class<? extends Augmentation<Selector>>, Augmentation<Selector>> augmentation = Map.of();

    public SelectorBuilder() {
    }

    public SelectorBuilder(Selector base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Selector>>, Augmentation<Selector>>(aug);
        }
        this.key = base.key();
        this._facility = base.getFacility();
        this._severity = base.getSeverity();
        this._config = base.getConfig();
        this._state = base.getState();
    }

    public SelectorKey key() {
        return this.key;
    }

    public Config getConfig() {
        return this._config;
    }

    public SYSLOGFACILITY getFacility() {
        return this._facility;
    }

    public SyslogSeverity getSeverity() {
        return this._severity;
    }

    public State getState() {
        return this._state;
    }

    public <E$$ extends Augmentation<Selector>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public SelectorBuilder withKey(SelectorKey key) {
        this.key = key;
        return this;
    }

    public SelectorBuilder setConfig(Config value) {
        this._config = value;
        return this;
    }

    public SelectorBuilder setFacility(SYSLOGFACILITY value) {
        this._facility = value;
        return this;
    }

    public SelectorBuilder setSeverity(SyslogSeverity value) {
        this._severity = value;
        return this;
    }

    public SelectorBuilder setState(State value) {
        this._state = value;
        return this;
    }

    public SelectorBuilder addAugmentation(Augmentation<Selector> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Selector>>, Augmentation<Selector>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public SelectorBuilder removeAugmentation(Class<? extends Augmentation<Selector>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Selector build() {
        return new SelectorImpl(this);
    }

    private static final class SelectorImpl
    extends AbstractAugmentable<Selector>
    implements Selector {
        private final Config _config;
        private final SYSLOGFACILITY _facility;
        private final SyslogSeverity _severity;
        private final State _state;
        private final SelectorKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        SelectorImpl(SelectorBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new SelectorKey(base.getFacility(), base.getSeverity());
            this._facility = this.key.getFacility();
            this._severity = this.key.getSeverity();
            this._config = base.getConfig();
            this._state = base.getState();
        }

        @Override
        public SelectorKey key() {
            return this.key;
        }

        @Override
        public Config getConfig() {
            return this._config;
        }

        @Override
        public SYSLOGFACILITY getFacility() {
            return this._facility;
        }

        @Override
        public SyslogSeverity getSeverity() {
            return this._severity;
        }

        @Override
        public State getState() {
            return this._state;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Selector.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Selector.bindingEquals(this, obj);
        }

        public String toString() {
            return Selector.bindingToString(this);
        }
    }
}

