/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.remote.top.remote.servers.remote.server;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.LoggingRemoteConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.LoggingRemoteState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.remote.top.remote.servers.remote.server.State;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.Host;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.IpAddress;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.PortNumber;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class StateBuilder {
    private Host _host;
    private PortNumber _remotePort;
    private IpAddress _sourceAddress;
    Map<Class<? extends Augmentation<State>>, Augmentation<State>> augmentation = Map.of();

    public StateBuilder() {
    }

    public StateBuilder(LoggingRemoteConfig arg) {
        this._host = arg.getHost();
        this._sourceAddress = arg.getSourceAddress();
        this._remotePort = arg.getRemotePort();
    }

    public StateBuilder(LoggingRemoteState arg) {
    }

    public StateBuilder(State base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<State>>, Augmentation<State>>(aug);
        }
        this._host = base.getHost();
        this._remotePort = base.getRemotePort();
        this._sourceAddress = base.getSourceAddress();
    }

    public void fieldsFrom(DataObject arg) {
        Object castArg;
        boolean isValidArg = false;
        if (arg instanceof LoggingRemoteConfig) {
            castArg = (LoggingRemoteConfig)arg;
            this._host = castArg.getHost();
            this._sourceAddress = castArg.getSourceAddress();
            this._remotePort = castArg.getRemotePort();
            isValidArg = true;
        }
        if (arg instanceof LoggingRemoteState) {
            castArg = (LoggingRemoteState)arg;
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[LoggingRemoteConfig, LoggingRemoteState]");
    }

    public Host getHost() {
        return this._host;
    }

    public PortNumber getRemotePort() {
        return this._remotePort;
    }

    public IpAddress getSourceAddress() {
        return this._sourceAddress;
    }

    public <E$$ extends Augmentation<State>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public StateBuilder setHost(Host value) {
        this._host = value;
        return this;
    }

    public StateBuilder setRemotePort(PortNumber value) {
        this._remotePort = value;
        return this;
    }

    public StateBuilder setSourceAddress(IpAddress value) {
        this._sourceAddress = value;
        return this;
    }

    public StateBuilder addAugmentation(Augmentation<State> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<State>>, Augmentation<State>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public StateBuilder removeAugmentation(Class<? extends Augmentation<State>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull State build() {
        return new StateImpl(this);
    }

    private static final class StateImpl
    extends AbstractAugmentable<State>
    implements State {
        private final Host _host;
        private final PortNumber _remotePort;
        private final IpAddress _sourceAddress;
        private int hash = 0;
        private volatile boolean hashValid = false;

        StateImpl(StateBuilder base) {
            super(base.augmentation);
            this._host = base.getHost();
            this._remotePort = base.getRemotePort();
            this._sourceAddress = base.getSourceAddress();
        }

        @Override
        public Host getHost() {
            return this._host;
        }

        @Override
        public PortNumber getRemotePort() {
            return this._remotePort;
        }

        @Override
        public IpAddress getSourceAddress() {
            return this._sourceAddress;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = State.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return State.bindingEquals(this, obj);
        }

        public String toString() {
            return State.bindingToString(this);
        }
    }
}

