/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.types.rev200630;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Enumeration;

public enum Transport implements Enumeration
{
    TCP(0, "TCP"),
    TLS(1, "TLS");

    private final @NonNull String name;
    private final int value;

    private Transport(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public @NonNull String getName() {
        return this.name;
    }

    public int getIntValue() {
        return this.value;
    }

    public static @Nullable Transport forName(String name) {
        return switch (name) {
            case "TCP" -> TCP;
            case "TLS" -> TLS;
            default -> null;
        };
    }

    public static @Nullable Transport forValue(int intValue) {
        return switch (intValue) {
            case 0 -> TCP;
            case 1 -> TLS;
            default -> null;
        };
    }

    public static @NonNull Transport ofName(String name) {
        return (Transport)CodeHelpers.checkEnum((Enumeration)Transport.forName(name), (String)name);
    }

    public static @NonNull Transport ofValue(int intValue) {
        return (Transport)CodeHelpers.checkEnum((Enumeration)Transport.forValue(intValue), (int)intValue);
    }
}

