/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.ethernet.top;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.ethernet.top.Ethernet;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.ethernet.top.ethernet.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.ethernet.top.ethernet.State;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class EthernetBuilder {
    private Config _config;
    private State _state;
    Map<Class<? extends Augmentation<Ethernet>>, Augmentation<Ethernet>> augmentation = Map.of();

    public EthernetBuilder() {
    }

    public EthernetBuilder(Ethernet base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Ethernet>>, Augmentation<Ethernet>>(aug);
        }
        this._config = base.getConfig();
        this._state = base.getState();
    }

    public Config getConfig() {
        return this._config;
    }

    public State getState() {
        return this._state;
    }

    public <E$$ extends Augmentation<Ethernet>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public EthernetBuilder setConfig(Config value) {
        this._config = value;
        return this;
    }

    public EthernetBuilder setState(State value) {
        this._state = value;
        return this;
    }

    public EthernetBuilder addAugmentation(Augmentation<Ethernet> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Ethernet>>, Augmentation<Ethernet>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public EthernetBuilder removeAugmentation(Class<? extends Augmentation<Ethernet>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Ethernet build() {
        return new EthernetImpl(this);
    }

    private static final class EthernetImpl
    extends AbstractAugmentable<Ethernet>
    implements Ethernet {
        private final Config _config;
        private final State _state;
        private int hash = 0;
        private volatile boolean hashValid = false;

        EthernetImpl(EthernetBuilder base) {
            super(base.augmentation);
            this._config = base.getConfig();
            this._state = base.getState();
        }

        @Override
        public Config getConfig() {
            return this._config;
        }

        @Override
        public State getState() {
            return this._state;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Ethernet.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Ethernet.bindingEquals(this, obj);
        }

        public String toString() {
            return Ethernet.bindingToString(this);
        }
    }
}

