/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.servergroup.common.top.server.groups;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.AaaServerTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.server.top.Servers;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.servergroup.common.top.server.groups.ServerGroup;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.servergroup.common.top.server.groups.ServerGroupKey;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.servergroup.common.top.server.groups.server.group.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.servergroup.common.top.server.groups.server.group.State;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ServerGroupBuilder {
    private Config _config;
    private String _name;
    private Servers _servers;
    private State _state;
    private ServerGroupKey key;
    Map<Class<? extends Augmentation<ServerGroup>>, Augmentation<ServerGroup>> augmentation = Map.of();

    public ServerGroupBuilder() {
    }

    public ServerGroupBuilder(AaaServerTop arg) {
        this._servers = arg.getServers();
    }

    public ServerGroupBuilder(ServerGroup base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ServerGroup>>, Augmentation<ServerGroup>>(aug);
        }
        this.key = base.key();
        this._name = base.getName();
        this._config = base.getConfig();
        this._servers = base.getServers();
        this._state = base.getState();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof AaaServerTop) {
            AaaServerTop castArg = (AaaServerTop)arg;
            this._servers = castArg.getServers();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[AaaServerTop]");
    }

    public ServerGroupKey key() {
        return this.key;
    }

    public Config getConfig() {
        return this._config;
    }

    public String getName() {
        return this._name;
    }

    public Servers getServers() {
        return this._servers;
    }

    public State getState() {
        return this._state;
    }

    public <E$$ extends Augmentation<ServerGroup>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ServerGroupBuilder withKey(ServerGroupKey key) {
        this.key = key;
        return this;
    }

    public ServerGroupBuilder setConfig(Config value) {
        this._config = value;
        return this;
    }

    public ServerGroupBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public ServerGroupBuilder setServers(Servers value) {
        this._servers = value;
        return this;
    }

    public ServerGroupBuilder setState(State value) {
        this._state = value;
        return this;
    }

    public ServerGroupBuilder addAugmentation(Augmentation<ServerGroup> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ServerGroup>>, Augmentation<ServerGroup>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public ServerGroupBuilder removeAugmentation(Class<? extends Augmentation<ServerGroup>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull ServerGroup build() {
        return new ServerGroupImpl(this);
    }

    private static final class ServerGroupImpl
    extends AbstractAugmentable<ServerGroup>
    implements ServerGroup {
        private final Config _config;
        private final String _name;
        private final Servers _servers;
        private final State _state;
        private final ServerGroupKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ServerGroupImpl(ServerGroupBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new ServerGroupKey(base.getName());
            this._name = this.key.getName();
            this._config = base.getConfig();
            this._servers = base.getServers();
            this._state = base.getState();
        }

        @Override
        public ServerGroupKey key() {
            return this.key;
        }

        @Override
        public Config getConfig() {
            return this._config;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public Servers getServers() {
            return this._servers;
        }

        @Override
        public State getState() {
            return this._state;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = ServerGroup.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return ServerGroup.bindingEquals(this, obj);
        }

        public String toString() {
            return ServerGroup.bindingToString(this);
        }
    }
}

