package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.members.state.members;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.rev210406.BaseInterfaceRefState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.rev210406.base._interface.ref.state.State;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link Member} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Member createMember(int fooXyzzy, int barBaz) {
 *         return new MemberBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Member, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Member
 *
 */
@Generated("mdsal-binding-generator")
public class MemberBuilder {

    private State _state;


    Map<Class<? extends Augmentation<Member>>, Augmentation<Member>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public MemberBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link BaseInterfaceRefState}.
     *
     * @param arg BaseInterfaceRefState from which the builder should be initialized
     */
    public MemberBuilder(BaseInterfaceRefState arg) {
        this._state = arg.getState();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link Member}.
     *
     * @param base Member from which the builder should be initialized
     */
    public MemberBuilder(Member base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._state = base.getState();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link BaseInterfaceRefState}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof BaseInterfaceRefState castArg) {
            this._state = castArg.getState();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[BaseInterfaceRefState]");
    }

    /**
     * Return current value associated with the property corresponding to {@link Member#getState()}.
     *
     * @return current value
     */
    public State getState() {
        return _state;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Member>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link Member#getState()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public MemberBuilder setState(final State value) {
        this._state = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public MemberBuilder addAugmentation(Augmentation<Member> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public MemberBuilder removeAugmentation(Class<? extends Augmentation<Member>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Member} instance.
     *
     * @return A new {@link Member} instance.
     */
    public @NonNull Member build() {
        return new MemberImpl(this);
    }

    private static final class MemberImpl
        extends AbstractAugmentable<Member>
        implements Member {
    
        private final State _state;
    
        MemberImpl(MemberBuilder base) {
            super(base.augmentation);
            this._state = base.getState();
        }
    
        @Override
        public State getState() {
            return _state;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Member.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Member.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Member.bindingToString(this);
        }
    }
}
