package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.match.top;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.VlanLogicalMatchTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.match.top.match.DoubleTagged;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.match.top.match.DoubleTaggedInnerList;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.match.top.match.DoubleTaggedInnerOuterRange;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.match.top.match.DoubleTaggedInnerRange;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.match.top.match.DoubleTaggedOuterList;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.match.top.match.DoubleTaggedOuterRange;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.match.top.match.SingleTagged;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.match.top.match.SingleTaggedList;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.match.top.match.SingleTaggedRange;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Configuration for various VLAN tag matching schemes, including single-tagged 
 * 802.1q packets and double-tagged 802.1ad 'Q-in-Q' packets. Typically only one 
 * the subordinate containers should be specified. Wildcards may be matched by 
 * specifying range values of 2-4094. If implementations have a more efficient way 
 * to match Wildcards then they should recognize this pattern and translate 
 * accordingly. Implementations are expected to return errors for combinations 
 * they do not support, or provide deviations to the same effect. For simple VLAN 
 * configurations without an 'egress-mapping' then using the 'single-tagged' and 
 * 'double-tagged' VLAN matches that resolve to specific values, these specify the 
 * VLAN identifiers applied to packets on egress.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-vlan</b>
 * <pre>
 * container match {
 *   container single-tagged {
 *     container config {
 *       uses vlan-logical-single-tagged-config;
 *     }
 *     container state {
 *       config false;
 *       uses vlan-logical-single-tagged-config;
 *     }
 *   }
 *   container single-tagged-list {
 *     container config {
 *       uses vlan-logical-single-tagged-list-config;
 *     }
 *     container state {
 *       config false;
 *       uses vlan-logical-single-tagged-list-config;
 *     }
 *   }
 *   container single-tagged-range {
 *     container config {
 *       uses vlan-logical-single-tagged-range-config;
 *     }
 *     container state {
 *       config false;
 *       uses vlan-logical-single-tagged-range-config;
 *     }
 *   }
 *   container double-tagged {
 *     container config {
 *       uses vlan-logical-double-tagged-config;
 *     }
 *     container state {
 *       config false;
 *       uses vlan-logical-double-tagged-config;
 *     }
 *   }
 *   container double-tagged-inner-list {
 *     container config {
 *       uses vlan-logical-double-tagged-inner-list-config;
 *     }
 *     container state {
 *       config false;
 *       uses vlan-logical-double-tagged-inner-list-config;
 *     }
 *   }
 *   container double-tagged-outer-list {
 *     container config {
 *       uses vlan-logical-double-tagged-outer-list-config;
 *     }
 *     container state {
 *       config false;
 *       uses vlan-logical-double-tagged-outer-list-config;
 *     }
 *   }
 *   container double-tagged-inner-range {
 *     container config {
 *       uses vlan-logical-double-tagged-inner-range-config;
 *     }
 *     container state {
 *       config false;
 *       uses vlan-logical-double-tagged-inner-range-config;
 *     }
 *   }
 *   container double-tagged-outer-range {
 *     container config {
 *       uses vlan-logical-double-tagged-outer-range-config;
 *     }
 *     container state {
 *       config false;
 *       uses vlan-logical-double-tagged-outer-range-config;
 *     }
 *   }
 *   container double-tagged-inner-outer-range {
 *     container config {
 *       uses vlan-logical-double-tagged-inner-outer-range-config;
 *     }
 *     container state {
 *       config false;
 *       uses vlan-logical-double-tagged-inner-outer-range-config;
 *     }
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link MatchBuilder}.
 * @see MatchBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Match
    extends
    ChildOf<VlanLogicalMatchTop>,
    Augmentable<Match>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("match");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.match.top.Match> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.match.top.Match.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.match.top.@NonNull Match obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getDoubleTagged());
        result = prime * result + Objects.hashCode(obj.getDoubleTaggedInnerList());
        result = prime * result + Objects.hashCode(obj.getDoubleTaggedInnerOuterRange());
        result = prime * result + Objects.hashCode(obj.getDoubleTaggedInnerRange());
        result = prime * result + Objects.hashCode(obj.getDoubleTaggedOuterList());
        result = prime * result + Objects.hashCode(obj.getDoubleTaggedOuterRange());
        result = prime * result + Objects.hashCode(obj.getSingleTagged());
        result = prime * result + Objects.hashCode(obj.getSingleTaggedList());
        result = prime * result + Objects.hashCode(obj.getSingleTaggedRange());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.match.top.@NonNull Match thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.match.top.Match other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.match.top.Match.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getDoubleTagged(), other.getDoubleTagged())) {
            return false;
        }
        if (!Objects.equals(thisObj.getDoubleTaggedInnerList(), other.getDoubleTaggedInnerList())) {
            return false;
        }
        if (!Objects.equals(thisObj.getDoubleTaggedInnerOuterRange(), other.getDoubleTaggedInnerOuterRange())) {
            return false;
        }
        if (!Objects.equals(thisObj.getDoubleTaggedInnerRange(), other.getDoubleTaggedInnerRange())) {
            return false;
        }
        if (!Objects.equals(thisObj.getDoubleTaggedOuterList(), other.getDoubleTaggedOuterList())) {
            return false;
        }
        if (!Objects.equals(thisObj.getDoubleTaggedOuterRange(), other.getDoubleTaggedOuterRange())) {
            return false;
        }
        if (!Objects.equals(thisObj.getSingleTagged(), other.getSingleTagged())) {
            return false;
        }
        if (!Objects.equals(thisObj.getSingleTaggedList(), other.getSingleTaggedList())) {
            return false;
        }
        if (!Objects.equals(thisObj.getSingleTaggedRange(), other.getSingleTaggedRange())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.match.top.@NonNull Match obj) {
        final var helper = MoreObjects.toStringHelper("Match");
        CodeHelpers.appendValue(helper, "doubleTagged", obj.getDoubleTagged());
        CodeHelpers.appendValue(helper, "doubleTaggedInnerList", obj.getDoubleTaggedInnerList());
        CodeHelpers.appendValue(helper, "doubleTaggedInnerOuterRange", obj.getDoubleTaggedInnerOuterRange());
        CodeHelpers.appendValue(helper, "doubleTaggedInnerRange", obj.getDoubleTaggedInnerRange());
        CodeHelpers.appendValue(helper, "doubleTaggedOuterList", obj.getDoubleTaggedOuterList());
        CodeHelpers.appendValue(helper, "doubleTaggedOuterRange", obj.getDoubleTaggedOuterRange());
        CodeHelpers.appendValue(helper, "singleTagged", obj.getSingleTagged());
        CodeHelpers.appendValue(helper, "singleTaggedList", obj.getSingleTaggedList());
        CodeHelpers.appendValue(helper, "singleTaggedRange", obj.getSingleTaggedRange());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return singleTagged, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Match single-tagged packets with an exact VLAN identifier.
     *     </code>
     * </pre>
     *
     * @return {@code SingleTagged} singleTagged, or {@code null} if it is not present.
     *
     */
    SingleTagged getSingleTagged();
    
    /**
     * Return singleTaggedList, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Match single-tagged packets with a list of VLAN identifiers.
     *     </code>
     * </pre>
     *
     * @return {@code SingleTaggedList} singleTaggedList, or {@code null} if it is not present.
     *
     */
    SingleTaggedList getSingleTaggedList();
    
    /**
     * Return singleTaggedRange, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Match single-tagged packets with a range of VLAN identifiers.
     *     </code>
     * </pre>
     *
     * @return {@code SingleTaggedRange} singleTaggedRange, or {@code null} if it is not present.
     *
     */
    SingleTaggedRange getSingleTaggedRange();
    
    /**
     * Return doubleTagged, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Match double-tagged packets against inner exact and outer exact VLAN
     *         identifiers.
     *     </code>
     * </pre>
     *
     * @return {@code DoubleTagged} doubleTagged, or {@code null} if it is not present.
     *
     */
    DoubleTagged getDoubleTagged();
    
    /**
     * Return doubleTaggedInnerList, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Match double-tagged packets against an inner list and outer exact VLAN
     *         identifiers.
     *     </code>
     * </pre>
     *
     * @return {@code DoubleTaggedInnerList} doubleTaggedInnerList, or {@code null} if it is not present.
     *
     */
    DoubleTaggedInnerList getDoubleTaggedInnerList();
    
    /**
     * Return doubleTaggedOuterList, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Match double-tagged packets against an inner exact and outer list of VLAN
     *         identifiers.
     *     </code>
     * </pre>
     *
     * @return {@code DoubleTaggedOuterList} doubleTaggedOuterList, or {@code null} if it is not present.
     *
     */
    DoubleTaggedOuterList getDoubleTaggedOuterList();
    
    /**
     * Return doubleTaggedInnerRange, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Match double-tagged packets against an inner range and outer exact VLAN
     *         identifiers.
     *     </code>
     * </pre>
     *
     * @return {@code DoubleTaggedInnerRange} doubleTaggedInnerRange, or {@code null} if it is not present.
     *
     */
    DoubleTaggedInnerRange getDoubleTaggedInnerRange();
    
    /**
     * Return doubleTaggedOuterRange, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Match double-tagged packets against an inner exact and an outer range of VLAN
     *         identifiers.
     *     </code>
     * </pre>
     *
     * @return {@code DoubleTaggedOuterRange} doubleTaggedOuterRange, or {@code null} if it is not present.
     *
     */
    DoubleTaggedOuterRange getDoubleTaggedOuterRange();
    
    /**
     * Return doubleTaggedInnerOuterRange, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Match double-tagged packets against an inner range and an outer range of VLAN
     *         identifiers.
     *     </code>
     * </pre>
     *
     * @return {@code DoubleTaggedInnerOuterRange} doubleTaggedInnerOuterRange, or {@code null} if it is not present.
     *
     */
    DoubleTaggedInnerOuterRange getDoubleTaggedInnerOuterRange();

}

