package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.switched.top.SwitchedVlan;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Top-level grouping for VLAN data associated with an Ethernet interface
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-vlan</b>
 * <pre>
 * grouping vlan-switched-top {
 *   container switched-vlan {
 *     container config {
 *       uses vlan-switched-config;
 *     }
 *     container state {
 *       config false;
 *       uses vlan-switched-config;
 *       uses vlan-switched-state;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface VlanSwitchedTop
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("vlan-switched-top");

    @Override
    Class<? extends VlanSwitchedTop> implementedInterface();
    
    /**
     * Return switchedVlan, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Enclosing container for VLAN interface-specific data on Ethernet interfaces.
     *         These are for standard L2, switched-style VLANs.
     *     </code>
     * </pre>
     *
     * @return {@code SwitchedVlan} switchedVlan, or {@code null} if it is not present.
     *
     */
    SwitchedVlan getSwitchedVlan();

}

