package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.TypeObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint16;

/**
 * Configuration data for routed vlans (SVI, IRB, etc.)
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-vlan</b>
 * <pre>
 * grouping vlan-routed-config {
 *   leaf vlan {
 *     type union {
 *       type uint16;
 *       type string;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface VlanRoutedConfig
    extends
    DataObject
{

    /**
     *
     * <p>
     * This class represents the following YANG schema fragment defined in module <b>openconfig-vlan</b>
     * <pre>
     * leaf vlan {
     *   type union {
     *     type uint16;
     *     type string;
     *   }
     * }
     * </pre>
     *
     */
    public static final class Vlan
     implements TypeObject, Serializable {
        private static final long serialVersionUID = -1849881313487059021L;
        private final Uint16 _uint16;
        private final String _string;
    
    
        public Vlan(Uint16 _uint16) {
            super();
            this._uint16 = _uint16;
            this._string = null;
        }
        
        public Vlan(String _string) {
            super();
            this._string = _string;
            this._uint16 = null;
        }
        /**
         * Creates a copy from Source Object.
         *
         * @param source Source object
         */
        public Vlan(Vlan source) {
            this._uint16 = source._uint16;
            this._string = source._string;
        }
        
        /**
         * Return a String representing the value of this union.
         *
         * @return String representation of this union's value.
         */
        public String stringValue() {
            if (_uint16 != null) {
                return _uint16.toCanonicalString();
            }
            if (_string != null) {
                return _string;
            }
            throw new IllegalStateException("No value assigned");
        }
    
    
        public Uint16 getUint16() {
            return _uint16;
        }
        
        public String getString() {
            return _string;
        }
    
    
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_uint16);
            result = prime * result + Objects.hashCode(_string);
            return result;
        }
    
        @Override
        public final boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Vlan)) {
                return false;
            }
            final Vlan other = (Vlan) obj;
            if (!Objects.equals(_uint16, other._uint16)) {
                return false;
            }
            if (!Objects.equals(_string, other._string)) {
                return false;
            }
            return true;
        }
    
        @Override
        public String toString() {
            final var helper = MoreObjects.toStringHelper(Vlan.class);
            CodeHelpers.appendValue(helper, "uint16", _uint16);
            CodeHelpers.appendValue(helper, "string", _string);
            return helper.toString();
        }
    }
    


    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("vlan-routed-config");

    @Override
    Class<? extends VlanRoutedConfig> implementedInterface();
    
    /**
     * Return vlan, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         References the VLAN for which this IP interface provides routing services --
     *         similar to a switch virtual interface (SVI), or integrated routing and bridging
     *         interface (IRB) in some implementations.
     *     </code>
     * </pre>
     *
     * @return {@code Vlan} vlan, or {@code null} if it is not present.
     *
     */
    Vlan getVlan();
    
    /**
     * Return vlan, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         References the VLAN for which this IP interface provides routing services --
     *         similar to a switch virtual interface (SVI), or integrated routing and bridging
     *         interface (IRB) in some implementations.
     *     </code>
     * </pre>
     *
     * @return {@code Vlan} vlan, guaranteed to be non-null.
     * @throws NoSuchElementException if vlan is not present
     *
     */
    default @NonNull Vlan requireVlan() {
        return CodeHelpers.require(getVlan(), "vlan");
    }

}

