package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Enumeration;

@Generated("mdsal-binding-generator")
public enum IpVersion implements Enumeration {
    /**
     * An unknown or unspecified version of the Internet
     * protocol.
     */
    UNKNOWN(0, "UNKNOWN"),
    
    /**
     * The IPv4 protocol as defined in RFC 791.
     */
    IPV4(4, "IPV4"),
    
    /**
     * The IPv6 protocol as defined in RFC 2460.
     */
    IPV6(6, "IPV6")
    ;

    private final @NonNull String name;
    private final int value;

    private IpVersion(int value, @NonNull String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public @NonNull String getName() {
        return name;
    }

    @Override
    public int getIntValue() {
        return value;
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified assigned name.
     *
     * @param name YANG assigned name
     * @return corresponding IpVersion item, or {@code null} if no such item exists
     * @throws NullPointerException if {@code name} is null
     */
    public static @Nullable IpVersion forName(String name) {
        return switch (name) {
            case "UNKNOWN" -> UNKNOWN;
            case "IPV4" -> IPV4;
            case "IPV6" -> IPV6;
            default -> null;
        };
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding IpVersion item, or {@code null} if no such item exists
     */
    public static @Nullable IpVersion forValue(int intValue) {
        return switch (intValue) {
            case 0 -> UNKNOWN;
            case 4 -> IPV4;
            case 6 -> IPV6;
            default -> null;
        };
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified assigned name.
     *
     * @param name YANG assigned name
     * @return corresponding IpVersion item
     * @throws NullPointerException if {@code name} is null
     * @throws IllegalArgumentException if {@code name} does not match any item
     */
    public static @NonNull IpVersion ofName(String name) {
        return CodeHelpers.checkEnum(forName(name), name);
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding IpVersion item
     * @throws IllegalArgumentException if {@code intValue} does not match any item
     */
    public static @NonNull IpVersion ofValue(int intValue) {
        return CodeHelpers.checkEnum(forValue(intValue), intValue);
    }
}
