package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint16;

/**
 * Common configuration data for terminal services
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system-terminal</b>
 * <pre>
 * grouping system-terminal-common-config {
 *   leaf timeout {
 *     type uint16;
 *     units seconds;
 *   }
 *   leaf rate-limit {
 *     type uint16;
 *     units conn/min;
 *   }
 *   leaf session-limit {
 *     type uint16;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface SystemTerminalCommonConfig
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("system-terminal-common-config");

    @Override
    Class<? extends SystemTerminalCommonConfig> implementedInterface();
    
    /**
     * Return timeout, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Set the idle timeout in seconds on terminal connections to the system for the
     *         protocol.
     *     </code>
     * </pre>
     *
     * @return {@code Uint16} timeout, or {@code null} if it is not present.
     *
     */
    Uint16 getTimeout();
    
    /**
     * Return timeout, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Set the idle timeout in seconds on terminal connections to the system for the
     *         protocol.
     *     </code>
     * </pre>
     *
     * @return {@code Uint16} timeout, guaranteed to be non-null.
     * @throws NoSuchElementException if timeout is not present
     *
     */
    default @NonNull Uint16 requireTimeout() {
        return CodeHelpers.require(getTimeout(), "timeout");
    }
    
    /**
     * Return rateLimit, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Set a limit on the number of connection attempts per minute to the system for
     *         the protocol.
     *     </code>
     * </pre>
     *
     * @return {@code Uint16} rateLimit, or {@code null} if it is not present.
     *
     */
    Uint16 getRateLimit();
    
    /**
     * Return rateLimit, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Set a limit on the number of connection attempts per minute to the system for
     *         the protocol.
     *     </code>
     * </pre>
     *
     * @return {@code Uint16} rateLimit, guaranteed to be non-null.
     * @throws NoSuchElementException if rateLimit is not present
     *
     */
    default @NonNull Uint16 requireRateLimit() {
        return CodeHelpers.require(getRateLimit(), "ratelimit");
    }
    
    /**
     * Return sessionLimit, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Set a limit on the number of simultaneous active terminal sessions to the system
     *         for the protocol (e.g., ssh, telnet, ...) 
     *     </code>
     * </pre>
     *
     * @return {@code Uint16} sessionLimit, or {@code null} if it is not present.
     *
     */
    Uint16 getSessionLimit();
    
    /**
     * Return sessionLimit, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Set a limit on the number of simultaneous active terminal sessions to the system
     *         for the protocol (e.g., ssh, telnet, ...) 
     *     </code>
     * </pre>
     *
     * @return {@code Uint16} sessionLimit, guaranteed to be non-null.
     * @throws NoSuchElementException if sessionLimit is not present
     *
     */
    default @NonNull Uint16 requireSessionLimit() {
        return CodeHelpers.require(getSessionLimit(), "sessionlimit");
    }

}

