package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint64;

/**
 * Operational state data for system memory
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system</b>
 * <pre>
 * grouping system-memory-state {
 *   leaf physical {
 *     type uint64;
 *     units bytes;
 *   }
 *   leaf reserved {
 *     type uint64;
 *     units bytes;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface SystemMemoryState
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("system-memory-state");

    @Override
    Class<? extends SystemMemoryState> implementedInterface();
    
    /**
     * Return physical, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Reports the total physical memory available on the system.
     *     </code>
     * </pre>
     *
     * @return {@code Uint64} physical, or {@code null} if it is not present.
     *
     */
    Uint64 getPhysical();
    
    /**
     * Return physical, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Reports the total physical memory available on the system.
     *     </code>
     * </pre>
     *
     * @return {@code Uint64} physical, guaranteed to be non-null.
     * @throws NoSuchElementException if physical is not present
     *
     */
    default @NonNull Uint64 requirePhysical() {
        return CodeHelpers.require(getPhysical(), "physical");
    }
    
    /**
     * Return reserved, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Memory reserved for system use
     *     </code>
     * </pre>
     *
     * @return {@code Uint64} reserved, or {@code null} if it is not present.
     *
     */
    Uint64 getReserved();
    
    /**
     * Return reserved, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Memory reserved for system use
     *     </code>
     * </pre>
     *
     * @return {@code Uint64} reserved, guaranteed to be non-null.
     * @throws NoSuchElementException if reserved is not present
     *
     */
    default @NonNull Uint64 requireReserved() {
        return CodeHelpers.require(getReserved(), "reserved");
    }

}

