package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.procmon.rev190315;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.yang.binding.DataRoot;

/**
 * This module provides data definitions for process health monitoring of one or 
 * more processes running on the system.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-procmon</b>
 * <pre>
 * module openconfig-procmon {
 *   yang-version 1;
 *   namespace "http://openconfig.net/yang/system/procmon";
 *   prefix oc-proc;
 *   import openconfig-extensions {
 *     prefix oc-ext;
 *   }
 *   import openconfig-types {
 *     prefix oc-types;
 *   }
 *   import openconfig-yang-types {
 *     prefix oc-yang;
 *   }
 *   oc-ext:openconfig-version 0.4.0;
 *   revision 2019-03-15 {
 *   }
 *   revision 2018-11-21 {
 *   }
 *   revision 2017-09-18 {
 *   }
 *   revision 2017-07-06 {
 *   }
 *   revision 2017-01-29 {
 *   }
 *   oc-ext:regexp-posix;
 *   oc-ext:catalog-organization openconfig;
 *   oc-ext:origin openconfig;
 *   grouping procmon-processes-top {
 *     container processes {
 *       list process {
 *         key pid;
 *         config false;
 *         leaf pid {
 *           type leafref {
 *             path ../state/pid;
 *           }
 *         }
 *         container state {
 *           config false;
 *           uses procmon-process-attributes-state;
 *         }
 *       }
 *     }
 *   }
 *   grouping procmon-process-attributes-state {
 *     leaf pid {
 *       type uint64;
 *     }
 *     leaf name {
 *       type string;
 *     }
 *     leaf-list args {
 *       type string;
 *     }
 *     leaf start-time {
 *       type oc-types:timeticks64;
 *     }
 *     leaf cpu-usage-user {
 *       type oc-yang:counter64;
 *       units nanoseconds;
 *     }
 *     leaf cpu-usage-system {
 *       type oc-yang:counter64;
 *       units nanoseconds;
 *     }
 *     leaf cpu-utilization {
 *       type oc-types:percentage;
 *     }
 *     leaf memory-usage {
 *       type uint64;
 *       units bytes;
 *     }
 *     leaf memory-utilization {
 *       type oc-types:percentage;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface OpenconfigProcmonData
    extends
    DataRoot
{





}

