package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Enumeration;

@Generated("mdsal-binding-generator")
public enum SyslogSeverity implements Enumeration {
    /**
     * Emergency: system is unusable (0)
     */
    EMERGENCY(0, "EMERGENCY"),
    
    /**
     * Alert: action must be taken immediately (1)
     */
    ALERT(1, "ALERT"),
    
    /**
     * Critical: critical conditions (2)
     */
    CRITICAL(2, "CRITICAL"),
    
    /**
     * Error: error conditions (3)
     */
    ERROR(3, "ERROR"),
    
    /**
     * Warning: warning conditions (4)
     */
    WARNING(4, "WARNING"),
    
    /**
     * Notice: normal but significant  condition(5)
     */
    NOTICE(5, "NOTICE"),
    
    /**
     * Informational: informational messages (6)
     */
    INFORMATIONAL(6, "INFORMATIONAL"),
    
    /**
     * Debug: debug-level messages (7)
     */
    DEBUG(7, "DEBUG")
    ;

    private final @NonNull String name;
    private final int value;

    private SyslogSeverity(int value, @NonNull String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public @NonNull String getName() {
        return name;
    }

    @Override
    public int getIntValue() {
        return value;
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified assigned name.
     *
     * @param name YANG assigned name
     * @return corresponding SyslogSeverity item, or {@code null} if no such item exists
     * @throws NullPointerException if {@code name} is null
     */
    public static @Nullable SyslogSeverity forName(String name) {
        return switch (name) {
            case "EMERGENCY" -> EMERGENCY;
            case "ALERT" -> ALERT;
            case "CRITICAL" -> CRITICAL;
            case "ERROR" -> ERROR;
            case "WARNING" -> WARNING;
            case "NOTICE" -> NOTICE;
            case "INFORMATIONAL" -> INFORMATIONAL;
            case "DEBUG" -> DEBUG;
            default -> null;
        };
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding SyslogSeverity item, or {@code null} if no such item exists
     */
    public static @Nullable SyslogSeverity forValue(int intValue) {
        return switch (intValue) {
            case 0 -> EMERGENCY;
            case 1 -> ALERT;
            case 2 -> CRITICAL;
            case 3 -> ERROR;
            case 4 -> WARNING;
            case 5 -> NOTICE;
            case 6 -> INFORMATIONAL;
            case 7 -> DEBUG;
            default -> null;
        };
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified assigned name.
     *
     * @param name YANG assigned name
     * @return corresponding SyslogSeverity item
     * @throws NullPointerException if {@code name} is null
     * @throws IllegalArgumentException if {@code name} does not match any item
     */
    public static @NonNull SyslogSeverity ofName(String name) {
        return CodeHelpers.checkEnum(forName(name), name);
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding SyslogSeverity item
     * @throws IllegalArgumentException if {@code intValue} does not match any item
     */
    public static @NonNull SyslogSeverity ofValue(int intValue) {
        return CodeHelpers.checkEnum(forValue(intValue), intValue);
    }
}
