package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.yang.binding.DataRoot;

/**
 * This module defines configuration and operational state data for common logging 
 * facilities on network systems.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system-logging</b>
 * <pre>
 * module openconfig-system-logging {
 *   yang-version 1;
 *   namespace "http://openconfig.net/yang/system/logging";
 *   prefix oc-log;
 *   import openconfig-extensions {
 *     prefix oc-ext;
 *   }
 *   import openconfig-inet-types {
 *     prefix oc-inet;
 *   }
 *   oc-ext:openconfig-version 0.3.1;
 *   revision 2018-11-21 {
 *   }
 *   revision 2017-09-18 {
 *   }
 *   revision 2017-07-06 {
 *   }
 *   revision 2017-01-29 {
 *   }
 *   oc-ext:regexp-posix;
 *   oc-ext:catalog-organization openconfig;
 *   oc-ext:origin openconfig;
 *   identity SYSLOG_FACILITY {
 *   }
 *   identity ALL {
 *     base SYSLOG_FACILITY;
 *   }
 *   identity KERNEL {
 *     base SYSLOG_FACILITY;
 *   }
 *   identity USER {
 *     base SYSLOG_FACILITY;
 *   }
 *   identity MAIL {
 *     base SYSLOG_FACILITY;
 *   }
 *   identity SYSTEM_DAEMON {
 *     base SYSLOG_FACILITY;
 *   }
 *   identity AUTH {
 *     base SYSLOG_FACILITY;
 *   }
 *   identity SYSLOG {
 *     base SYSLOG_FACILITY;
 *   }
 *   identity AUTHPRIV {
 *     base SYSLOG_FACILITY;
 *   }
 *   identity NTP {
 *     base SYSLOG_FACILITY;
 *   }
 *   identity AUDIT {
 *     base SYSLOG_FACILITY;
 *   }
 *   identity CONSOLE {
 *     base SYSLOG_FACILITY;
 *   }
 *   identity LOCAL0 {
 *     base SYSLOG_FACILITY;
 *   }
 *   identity LOCAL1 {
 *     base SYSLOG_FACILITY;
 *   }
 *   identity LOCAL2 {
 *     base SYSLOG_FACILITY;
 *   }
 *   identity LOCAL3 {
 *     base SYSLOG_FACILITY;
 *   }
 *   identity LOCAL4 {
 *     base SYSLOG_FACILITY;
 *   }
 *   identity LOCAL5 {
 *     base SYSLOG_FACILITY;
 *   }
 *   identity LOCAL6 {
 *     base SYSLOG_FACILITY;
 *   }
 *   identity LOCAL7 {
 *     base SYSLOG_FACILITY;
 *   }
 *   identity LOG_DESTINATION_TYPE {
 *   }
 *   identity DEST_CONSOLE {
 *     base LOG_DESTINATION_TYPE;
 *   }
 *   identity DEST_BUFFER {
 *     base LOG_DESTINATION_TYPE;
 *   }
 *   identity DEST_FILE {
 *     base LOG_DESTINATION_TYPE;
 *   }
 *   identity DEST_REMOTE {
 *     base LOG_DESTINATION_TYPE;
 *   }
 *   typedef syslog-severity {
 *     type enumeration {
 *       enum EMERGENCY {
 *       }
 *       enum ALERT {
 *       }
 *       enum CRITICAL {
 *       }
 *       enum ERROR {
 *       }
 *       enum WARNING {
 *       }
 *       enum NOTICE {
 *       }
 *       enum INFORMATIONAL {
 *       }
 *       enum DEBUG {
 *       }
 *     }
 *   }
 *   grouping logging-selectors-config {
 *     leaf facility {
 *       type identityref {
 *         base SYSLOG_FACILITY;
 *       }
 *     }
 *     leaf severity {
 *       type syslog-severity;
 *     }
 *   }
 *   grouping logging-selectors-state {
 *   }
 *   grouping logging-selectors-top {
 *     container selectors {
 *       list selector {
 *         key "facility severity";
 *         leaf facility {
 *           type leafref {
 *             path ../config/facility;
 *           }
 *         }
 *         leaf severity {
 *           type leafref {
 *             path ../config/severity;
 *           }
 *         }
 *         container config {
 *           uses logging-selectors-config;
 *         }
 *         container state {
 *           config false;
 *           uses logging-selectors-config;
 *           uses logging-selectors-state;
 *         }
 *       }
 *     }
 *   }
 *   grouping logging-console-config {
 *   }
 *   grouping logging-console-state {
 *   }
 *   grouping logging-console-top {
 *     container console {
 *       container config {
 *         uses logging-console-config;
 *       }
 *       container state {
 *         config false;
 *         uses logging-console-config;
 *         uses logging-console-state;
 *       }
 *       uses logging-selectors-top;
 *     }
 *   }
 *   grouping logging-remote-config {
 *     leaf host {
 *       type oc-inet:host;
 *     }
 *     leaf source-address {
 *       type oc-inet:ip-address;
 *     }
 *     leaf remote-port {
 *       type oc-inet:port-number;
 *       default 514;
 *     }
 *   }
 *   grouping logging-remote-state {
 *   }
 *   grouping logging-remote-top {
 *     container remote-servers {
 *       list remote-server {
 *         key host;
 *         leaf host {
 *           type leafref {
 *             path ../config/host;
 *           }
 *         }
 *         container config {
 *           uses logging-remote-config;
 *         }
 *         container state {
 *           config false;
 *           uses logging-remote-config;
 *           uses logging-remote-state;
 *         }
 *         uses logging-selectors-top;
 *       }
 *     }
 *   }
 *   grouping logging-top {
 *     container logging {
 *       uses logging-console-top;
 *       uses logging-remote-top;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface OpenconfigSystemLoggingData
    extends
    DataRoot
{





}

